<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDeviceMobility StructType
 * @subpackage Structs
 */
class XDeviceMobility extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The subNet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $subNet;
    /**
     * The subNetMaskSz
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $subNetMaskSz;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var Members
     */
    public $members;
    /**
     * Constructor method for XDeviceMobility
     * @uses XDeviceMobility::setName()
     * @uses XDeviceMobility::setSubNet()
     * @uses XDeviceMobility::setSubNetMaskSz()
     * @uses XDeviceMobility::setMembers()
     * @param string $name
     * @param string $subNet
     * @param string $subNetMaskSz
     * @param Members $members
     */
    public function __construct($name = null, $subNet = null, $subNetMaskSz = null, Members $members = null)
    {
        $this
            ->setName($name)
            ->setSubNet($subNet)
            ->setSubNetMaskSz($subNetMaskSz)
            ->setMembers($members);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XDeviceMobility
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get subNet value
     * @return string
     */
    public function getSubNet()
    {
        return $this->subNet;
    }
    /**
     * Set subNet value
     * @param string $subNet
     * @return XDeviceMobility
     */
    public function setSubNet($subNet = null)
    {
        // validation for constraint: string
        if (!is_null($subNet) && !is_string($subNet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subNet)), __LINE__);
        }
        $this->subNet = $subNet;
        return $this;
    }
    /**
     * Get subNetMaskSz value
     * @return string
     */
    public function getSubNetMaskSz()
    {
        return $this->subNetMaskSz;
    }
    /**
     * Set subNetMaskSz value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subNetMaskSz
     * @return XDeviceMobility
     */
    public function setSubNetMaskSz($subNetMaskSz = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($subNetMaskSz)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subNetMaskSz, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->subNetMaskSz = $subNetMaskSz;
        return $this;
    }
    /**
     * Get members value
     * @return Members
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return XDeviceMobility
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XDeviceMobility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
