<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAssignedPresenceUsers StructType
 * @subpackage Structs
 */
class XAssignedPresenceUsers extends AbstractStructBase
{
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userid;
    /**
     * The server
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $server;
    /**
     * The presenceRedundancyGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $presenceRedundancyGroup;
    /**
     * Constructor method for XAssignedPresenceUsers
     * @uses XAssignedPresenceUsers::setUserid()
     * @uses XAssignedPresenceUsers::setServer()
     * @uses XAssignedPresenceUsers::setPresenceRedundancyGroup()
     * @param string $userid
     * @param XFkType $server
     * @param string $presenceRedundancyGroup
     */
    public function __construct($userid = null, XFkType $server = null, $presenceRedundancyGroup = null)
    {
        $this
            ->setUserid($userid)
            ->setServer($server)
            ->setPresenceRedundancyGroup($presenceRedundancyGroup);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return XAssignedPresenceUsers
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get server value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getServer()
    {
        return isset($this->server) ? $this->server : null;
    }
    /**
     * Set server value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $server
     * @return XAssignedPresenceUsers
     */
    public function setServer(XFkType $server = null)
    {
        if (is_null($server) || (is_array($server) && empty($server))) {
            unset($this->server);
        } else {
            $this->server = $server;
        }
        return $this;
    }
    /**
     * Get presenceRedundancyGroup value
     * @return string|null
     */
    public function getPresenceRedundancyGroup()
    {
        return $this->presenceRedundancyGroup;
    }
    /**
     * Set presenceRedundancyGroup value
     * @param string $presenceRedundancyGroup
     * @return XAssignedPresenceUsers
     */
    public function setPresenceRedundancyGroup($presenceRedundancyGroup = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($presenceRedundancyGroup) && strlen($presenceRedundancyGroup) > 255) || (is_array($presenceRedundancyGroup) && count($presenceRedundancyGroup) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($presenceRedundancyGroup) ? strlen($presenceRedundancyGroup) : count($presenceRedundancyGroup)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($presenceRedundancyGroup) && !is_string($presenceRedundancyGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($presenceRedundancyGroup)), __LINE__);
        }
        $this->presenceRedundancyGroup = $presenceRedundancyGroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XAssignedPresenceUsers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
