<?php
/**
 * This class stands for XAppServerContent EnumType
 * @subpackage Enumerations
 */
class XAppServerContent
{
    /**
     * Constant for value 'UNITY KUBRIK'
     * @return string 'UNITY KUBRIK'
     */
    const VALUE_UNITY_KUBRIK = 'UNITY KUBRIK';
    /**
     * Constant for value 'UNITY PRE KUBRIK'
     * @return string 'UNITY PRE KUBRIK'
     */
    const VALUE_UNITY_PRE_KUBRIK = 'UNITY PRE KUBRIK';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNITY_KUBRIK
     * @uses self::VALUE_UNITY_PRE_KUBRIK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNITY_KUBRIK,
            self::VALUE_UNITY_PRE_KUBRIK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
