<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAdvertisedPatterns StructType
 * @subpackage Structs
 */
class XAdvertisedPatterns extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The pstnFailStrip
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pstnFailStrip;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The patternType
     * Meta informations extracted from the WSDL
     * - default: Enterprise Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternType;
    /**
     * The hostedRoutePSTNRule
     * Meta informations extracted from the WSDL
     * - default: Specify
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hostedRoutePSTNRule;
    /**
     * The pstnFailPrepend
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailPrepend;
    /**
     * Constructor method for XAdvertisedPatterns
     * @uses XAdvertisedPatterns::setPattern()
     * @uses XAdvertisedPatterns::setPstnFailStrip()
     * @uses XAdvertisedPatterns::setDescription()
     * @uses XAdvertisedPatterns::setPatternType()
     * @uses XAdvertisedPatterns::setHostedRoutePSTNRule()
     * @uses XAdvertisedPatterns::setPstnFailPrepend()
     * @param string $pattern
     * @param string $pstnFailStrip
     * @param string $description
     * @param string $patternType
     * @param string $hostedRoutePSTNRule
     * @param string $pstnFailPrepend
     */
    public function __construct($pattern = null, $pstnFailStrip = '0', $description = null, $patternType = 'Enterprise Number', $hostedRoutePSTNRule = 'Specify', $pstnFailPrepend = null)
    {
        $this
            ->setPattern($pattern)
            ->setPstnFailStrip($pstnFailStrip)
            ->setDescription($description)
            ->setPatternType($patternType)
            ->setHostedRoutePSTNRule($hostedRoutePSTNRule)
            ->setPstnFailPrepend($pstnFailPrepend);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return XAdvertisedPatterns
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get pstnFailStrip value
     * @return string
     */
    public function getPstnFailStrip()
    {
        return $this->pstnFailStrip;
    }
    /**
     * Set pstnFailStrip value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pstnFailStrip
     * @return XAdvertisedPatterns
     */
    public function setPstnFailStrip($pstnFailStrip = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($pstnFailStrip)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pstnFailStrip, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->pstnFailStrip = $pstnFailStrip;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XAdvertisedPatterns
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get patternType value
     * @return string|null
     */
    public function getPatternType()
    {
        return $this->patternType;
    }
    /**
     * Set patternType value
     * @uses XGlobalNumber::valueIsValid()
     * @uses XGlobalNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternType
     * @return XAdvertisedPatterns
     */
    public function setPatternType($patternType = 'Enterprise Number')
    {
        // validation for constraint: enumeration
        if (!XGlobalNumber::valueIsValid($patternType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $patternType, implode(', ', XGlobalNumber::getValidValues())), __LINE__);
        }
        $this->patternType = $patternType;
        return $this;
    }
    /**
     * Get hostedRoutePSTNRule value
     * @return string|null
     */
    public function getHostedRoutePSTNRule()
    {
        return $this->hostedRoutePSTNRule;
    }
    /**
     * Set hostedRoutePSTNRule value
     * @uses XHostedRoutePatternPSTNRule::valueIsValid()
     * @uses XHostedRoutePatternPSTNRule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hostedRoutePSTNRule
     * @return XAdvertisedPatterns
     */
    public function setHostedRoutePSTNRule($hostedRoutePSTNRule = 'Specify')
    {
        // validation for constraint: enumeration
        if (!XHostedRoutePatternPSTNRule::valueIsValid($hostedRoutePSTNRule)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hostedRoutePSTNRule, implode(', ', XHostedRoutePatternPSTNRule::getValidValues())), __LINE__);
        }
        $this->hostedRoutePSTNRule = $hostedRoutePSTNRule;
        return $this;
    }
    /**
     * Get pstnFailPrepend value
     * @return string|null
     */
    public function getPstnFailPrepend()
    {
        return $this->pstnFailPrepend;
    }
    /**
     * Set pstnFailPrepend value
     * @param string $pstnFailPrepend
     * @return XAdvertisedPatterns
     */
    public function setPstnFailPrepend($pstnFailPrepend = null)
    {
        // validation for constraint: string
        if (!is_null($pstnFailPrepend) && !is_string($pstnFailPrepend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnFailPrepend)), __LINE__);
        }
        $this->pstnFailPrepend = $pstnFailPrepend;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XAdvertisedPatterns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
