<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUserProfileProvisionReq StructType
 * @subpackage Structs
 */
class UpdateUserProfileProvisionReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The deskPhones
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $deskPhones;
    /**
     * The mobileDevices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $mobileDevices;
    /**
     * The profile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $profile;
    /**
     * The universalLineTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $universalLineTemplate;
    /**
     * The allowProvision
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowProvision;
    /**
     * The limitProvision
     * Meta informations extracted from the WSDL
     * - default: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $limitProvision;
    /**
     * The defaultUserProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $defaultUserProfile;
    /**
     * Constructor method for UpdateUserProfileProvisionReq
     * @uses UpdateUserProfileProvisionReq::setNewName()
     * @uses UpdateUserProfileProvisionReq::setDescription()
     * @uses UpdateUserProfileProvisionReq::setDeskPhones()
     * @uses UpdateUserProfileProvisionReq::setMobileDevices()
     * @uses UpdateUserProfileProvisionReq::setProfile()
     * @uses UpdateUserProfileProvisionReq::setUniversalLineTemplate()
     * @uses UpdateUserProfileProvisionReq::setAllowProvision()
     * @uses UpdateUserProfileProvisionReq::setLimitProvision()
     * @uses UpdateUserProfileProvisionReq::setDefaultUserProfile()
     * @param string $newName
     * @param string $description
     * @param XFkType $deskPhones
     * @param XFkType $mobileDevices
     * @param XFkType $profile
     * @param XFkType $universalLineTemplate
     * @param string $allowProvision
     * @param string $limitProvision
     * @param XFkType $defaultUserProfile
     */
    public function __construct($newName = null, $description = null, XFkType $deskPhones = null, XFkType $mobileDevices = null, XFkType $profile = null, XFkType $universalLineTemplate = null, $allowProvision = false, $limitProvision = '10', XFkType $defaultUserProfile = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDeskPhones($deskPhones)
            ->setMobileDevices($mobileDevices)
            ->setProfile($profile)
            ->setUniversalLineTemplate($universalLineTemplate)
            ->setAllowProvision($allowProvision)
            ->setLimitProvision($limitProvision)
            ->setDefaultUserProfile($defaultUserProfile);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateUserProfileProvisionReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateUserProfileProvisionReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get deskPhones value
     * @return XFkType|null
     */
    public function getDeskPhones()
    {
        return $this->deskPhones;
    }
    /**
     * Set deskPhones value
     * @param XFkType $deskPhones
     * @return UpdateUserProfileProvisionReq
     */
    public function setDeskPhones(XFkType $deskPhones = null)
    {
        $this->deskPhones = $deskPhones;
        return $this;
    }
    /**
     * Get mobileDevices value
     * @return XFkType|null
     */
    public function getMobileDevices()
    {
        return $this->mobileDevices;
    }
    /**
     * Set mobileDevices value
     * @param XFkType $mobileDevices
     * @return UpdateUserProfileProvisionReq
     */
    public function setMobileDevices(XFkType $mobileDevices = null)
    {
        $this->mobileDevices = $mobileDevices;
        return $this;
    }
    /**
     * Get profile value
     * @return XFkType|null
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @param XFkType $profile
     * @return UpdateUserProfileProvisionReq
     */
    public function setProfile(XFkType $profile = null)
    {
        $this->profile = $profile;
        return $this;
    }
    /**
     * Get universalLineTemplate value
     * @return XFkType|null
     */
    public function getUniversalLineTemplate()
    {
        return $this->universalLineTemplate;
    }
    /**
     * Set universalLineTemplate value
     * @param XFkType $universalLineTemplate
     * @return UpdateUserProfileProvisionReq
     */
    public function setUniversalLineTemplate(XFkType $universalLineTemplate = null)
    {
        $this->universalLineTemplate = $universalLineTemplate;
        return $this;
    }
    /**
     * Get allowProvision value
     * @return string|null
     */
    public function getAllowProvision()
    {
        return $this->allowProvision;
    }
    /**
     * Set allowProvision value
     * @param string $allowProvision
     * @return UpdateUserProfileProvisionReq
     */
    public function setAllowProvision($allowProvision = false)
    {
        // validation for constraint: pattern
        if (is_scalar($allowProvision) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowProvision, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowProvision) && !is_string($allowProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowProvision)), __LINE__);
        }
        $this->allowProvision = $allowProvision;
        return $this;
    }
    /**
     * Get limitProvision value
     * @return string|null
     */
    public function getLimitProvision()
    {
        return $this->limitProvision;
    }
    /**
     * Set limitProvision value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitProvision
     * @return UpdateUserProfileProvisionReq
     */
    public function setLimitProvision($limitProvision = '10')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($limitProvision)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $limitProvision, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->limitProvision = $limitProvision;
        return $this;
    }
    /**
     * Get defaultUserProfile value
     * @return XFkType|null
     */
    public function getDefaultUserProfile()
    {
        return $this->defaultUserProfile;
    }
    /**
     * Set defaultUserProfile value
     * @param XFkType $defaultUserProfile
     * @return UpdateUserProfileProvisionReq
     */
    public function setDefaultUserProfile(XFkType $defaultUserProfile = null)
    {
        $this->defaultUserProfile = $defaultUserProfile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateUserProfileProvisionReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
