<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRemoteClusterReq StructType
 * @subpackage Structs
 */
class UpdateRemoteClusterReq extends APIRequest
{
    /**
     * The clusterId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $clusterId;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The emcc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XRemoteClusterMember
     */
    public $emcc;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XRemoteClusterMember
     */
    public $pstnAccess;
    /**
     * The rsvpAgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XRemoteClusterMember
     */
    public $rsvpAgent;
    /**
     * The tftp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XRemoteClusterMember
     */
    public $tftp;
    /**
     * The lbm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XRemoteClusterMember
     */
    public $lbm;
    /**
     * The uds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XRemoteClusterMember
     */
    public $uds;
    /**
     * Constructor method for UpdateRemoteClusterReq
     * @uses UpdateRemoteClusterReq::setClusterId()
     * @uses UpdateRemoteClusterReq::setUuid()
     * @uses UpdateRemoteClusterReq::setEmcc()
     * @uses UpdateRemoteClusterReq::setPstnAccess()
     * @uses UpdateRemoteClusterReq::setRsvpAgent()
     * @uses UpdateRemoteClusterReq::setTftp()
     * @uses UpdateRemoteClusterReq::setLbm()
     * @uses UpdateRemoteClusterReq::setUds()
     * @param string $clusterId
     * @param string $uuid
     * @param XRemoteClusterMember $emcc
     * @param XRemoteClusterMember $pstnAccess
     * @param XRemoteClusterMember $rsvpAgent
     * @param XRemoteClusterMember $tftp
     * @param XRemoteClusterMember $lbm
     * @param XRemoteClusterMember $uds
     */
    public function __construct($clusterId = null, $uuid = null, XRemoteClusterMember $emcc = null, XRemoteClusterMember $pstnAccess = null, XRemoteClusterMember $rsvpAgent = null, XRemoteClusterMember $tftp = null, XRemoteClusterMember $lbm = null, XRemoteClusterMember $uds = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setUuid($uuid)
            ->setEmcc($emcc)
            ->setPstnAccess($pstnAccess)
            ->setRsvpAgent($rsvpAgent)
            ->setTftp($tftp)
            ->setLbm($lbm)
            ->setUds($uds);
    }
    /**
     * Get clusterId value
     * @return string
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return UpdateRemoteClusterReq
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clusterId) && strlen($clusterId) > 255) || (is_array($clusterId) && count($clusterId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clusterId) ? strlen($clusterId) : count($clusterId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return UpdateRemoteClusterReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get emcc value
     * @return XRemoteClusterMember|null
     */
    public function getEmcc()
    {
        return $this->emcc;
    }
    /**
     * Set emcc value
     * @param XRemoteClusterMember $emcc
     * @return UpdateRemoteClusterReq
     */
    public function setEmcc(XRemoteClusterMember $emcc = null)
    {
        $this->emcc = $emcc;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return XRemoteClusterMember|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param XRemoteClusterMember $pstnAccess
     * @return UpdateRemoteClusterReq
     */
    public function setPstnAccess(XRemoteClusterMember $pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get rsvpAgent value
     * @return XRemoteClusterMember|null
     */
    public function getRsvpAgent()
    {
        return $this->rsvpAgent;
    }
    /**
     * Set rsvpAgent value
     * @param XRemoteClusterMember $rsvpAgent
     * @return UpdateRemoteClusterReq
     */
    public function setRsvpAgent(XRemoteClusterMember $rsvpAgent = null)
    {
        $this->rsvpAgent = $rsvpAgent;
        return $this;
    }
    /**
     * Get tftp value
     * @return XRemoteClusterMember|null
     */
    public function getTftp()
    {
        return $this->tftp;
    }
    /**
     * Set tftp value
     * @param XRemoteClusterMember $tftp
     * @return UpdateRemoteClusterReq
     */
    public function setTftp(XRemoteClusterMember $tftp = null)
    {
        $this->tftp = $tftp;
        return $this;
    }
    /**
     * Get lbm value
     * @return XRemoteClusterMember|null
     */
    public function getLbm()
    {
        return $this->lbm;
    }
    /**
     * Set lbm value
     * @param XRemoteClusterMember $lbm
     * @return UpdateRemoteClusterReq
     */
    public function setLbm(XRemoteClusterMember $lbm = null)
    {
        $this->lbm = $lbm;
        return $this;
    }
    /**
     * Get uds value
     * @return XRemoteClusterMember|null
     */
    public function getUds()
    {
        return $this->uds;
    }
    /**
     * Set uds value
     * @param XRemoteClusterMember $uds
     * @return UpdateRemoteClusterReq
     */
    public function setUds(XRemoteClusterMember $uds = null)
    {
        $this->uds = $uds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateRemoteClusterReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
