<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePresenceGroupReq StructType
 * @subpackage Structs
 */
class UpdatePresenceGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The presenceGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PresenceGroups
     */
    public $presenceGroups;
    /**
     * Constructor method for UpdatePresenceGroupReq
     * @uses UpdatePresenceGroupReq::setNewName()
     * @uses UpdatePresenceGroupReq::setDescription()
     * @uses UpdatePresenceGroupReq::setPresenceGroups()
     * @param string $newName
     * @param string $description
     * @param PresenceGroups $presenceGroups
     */
    public function __construct($newName = null, $description = null, PresenceGroups $presenceGroups = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setPresenceGroups($presenceGroups);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdatePresenceGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return UpdatePresenceGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get presenceGroups value
     * @return PresenceGroups|null
     */
    public function getPresenceGroups()
    {
        return $this->presenceGroups;
    }
    /**
     * Set presenceGroups value
     * @param PresenceGroups $presenceGroups
     * @return UpdatePresenceGroupReq
     */
    public function setPresenceGroups(PresenceGroups $presenceGroups = null)
    {
        $this->presenceGroups = $presenceGroups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdatePresenceGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
