<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLdapDirectoryReq StructType
 * @subpackage Structs
 */
class UpdateLdapDirectoryReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The ldapDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $ldapDn;
    /**
     * The ldapPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $ldapPassword;
    /**
     * The userSearchBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $userSearchBase;
    /**
     * The repeatable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeatable;
    /**
     * The intervalValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $intervalValue;
    /**
     * The scheduleUnit
     * Meta informations extracted from the WSDL
     * - default: DAY
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $scheduleUnit;
    /**
     * The nextExecTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 32
     * @var string
     */
    public $nextExecTime;
    /**
     * The servers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Servers
     */
    public $servers;
    /**
     * The ldapFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $ldapFilter;
    /**
     * The removeAccessControlGroupInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RemoveAccessControlGroupInfo
     */
    public $removeAccessControlGroupInfo;
    /**
     * The addAccessControlGroupInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddAccessControlGroupInfo
     */
    public $addAccessControlGroupInfo;
    /**
     * The accessControlGroupInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AccessControlGroupInfo
     */
    public $accessControlGroupInfo;
    /**
     * The featureGroupTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $featureGroupTemplate;
    /**
     * The applyMask
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyMask;
    /**
     * The mask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mask;
    /**
     * The applyPoolList
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyPoolList;
    /**
     * The addDns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddDns
     */
    public $addDns;
    /**
     * Constructor method for UpdateLdapDirectoryReq
     * @uses UpdateLdapDirectoryReq::setNewName()
     * @uses UpdateLdapDirectoryReq::setLdapDn()
     * @uses UpdateLdapDirectoryReq::setLdapPassword()
     * @uses UpdateLdapDirectoryReq::setUserSearchBase()
     * @uses UpdateLdapDirectoryReq::setRepeatable()
     * @uses UpdateLdapDirectoryReq::setIntervalValue()
     * @uses UpdateLdapDirectoryReq::setScheduleUnit()
     * @uses UpdateLdapDirectoryReq::setNextExecTime()
     * @uses UpdateLdapDirectoryReq::setServers()
     * @uses UpdateLdapDirectoryReq::setLdapFilter()
     * @uses UpdateLdapDirectoryReq::setRemoveAccessControlGroupInfo()
     * @uses UpdateLdapDirectoryReq::setAddAccessControlGroupInfo()
     * @uses UpdateLdapDirectoryReq::setAccessControlGroupInfo()
     * @uses UpdateLdapDirectoryReq::setFeatureGroupTemplate()
     * @uses UpdateLdapDirectoryReq::setApplyMask()
     * @uses UpdateLdapDirectoryReq::setMask()
     * @uses UpdateLdapDirectoryReq::setApplyPoolList()
     * @uses UpdateLdapDirectoryReq::setAddDns()
     * @param string $newName
     * @param string $ldapDn
     * @param string $ldapPassword
     * @param string $userSearchBase
     * @param string $repeatable
     * @param string $intervalValue
     * @param string $scheduleUnit
     * @param string $nextExecTime
     * @param Servers $servers
     * @param XFkType $ldapFilter
     * @param RemoveAccessControlGroupInfo $removeAccessControlGroupInfo
     * @param AddAccessControlGroupInfo $addAccessControlGroupInfo
     * @param AccessControlGroupInfo $accessControlGroupInfo
     * @param XFkType $featureGroupTemplate
     * @param string $applyMask
     * @param string $mask
     * @param string $applyPoolList
     * @param AddDns $addDns
     */
    public function __construct($newName = null, $ldapDn = null, $ldapPassword = null, $userSearchBase = null, $repeatable = null, $intervalValue = null, $scheduleUnit = 'DAY', $nextExecTime = null, Servers $servers = null, XFkType $ldapFilter = null, RemoveAccessControlGroupInfo $removeAccessControlGroupInfo = null, AddAccessControlGroupInfo $addAccessControlGroupInfo = null, AccessControlGroupInfo $accessControlGroupInfo = null, XFkType $featureGroupTemplate = null, $applyMask = false, $mask = null, $applyPoolList = false, AddDns $addDns = null)
    {
        $this
            ->setNewName($newName)
            ->setLdapDn($ldapDn)
            ->setLdapPassword($ldapPassword)
            ->setUserSearchBase($userSearchBase)
            ->setRepeatable($repeatable)
            ->setIntervalValue($intervalValue)
            ->setScheduleUnit($scheduleUnit)
            ->setNextExecTime($nextExecTime)
            ->setServers($servers)
            ->setLdapFilter($ldapFilter)
            ->setRemoveAccessControlGroupInfo($removeAccessControlGroupInfo)
            ->setAddAccessControlGroupInfo($addAccessControlGroupInfo)
            ->setAccessControlGroupInfo($accessControlGroupInfo)
            ->setFeatureGroupTemplate($featureGroupTemplate)
            ->setApplyMask($applyMask)
            ->setMask($mask)
            ->setApplyPoolList($applyPoolList)
            ->setAddDns($addDns);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateLdapDirectoryReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string|null
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return UpdateLdapDirectoryReq
     */
    public function setLdapDn($ldapDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapDn) && strlen($ldapDn) > 128) || (is_array($ldapDn) && count($ldapDn) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ldapDn) ? strlen($ldapDn) : count($ldapDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapDn) && !is_string($ldapDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapDn)), __LINE__);
        }
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string|null
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return UpdateLdapDirectoryReq
     */
    public function setLdapPassword($ldapPassword = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapPassword) && strlen($ldapPassword) > 128) || (is_array($ldapPassword) && count($ldapPassword) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ldapPassword) ? strlen($ldapPassword) : count($ldapPassword)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapPassword) && !is_string($ldapPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapPassword)), __LINE__);
        }
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string|null
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return UpdateLdapDirectoryReq
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($userSearchBase) && strlen($userSearchBase) > 255) || (is_array($userSearchBase) && count($userSearchBase) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($userSearchBase) ? strlen($userSearchBase) : count($userSearchBase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userSearchBase) && !is_string($userSearchBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userSearchBase)), __LINE__);
        }
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get repeatable value
     * @return string|null
     */
    public function getRepeatable()
    {
        return $this->repeatable;
    }
    /**
     * Set repeatable value
     * @param string $repeatable
     * @return UpdateLdapDirectoryReq
     */
    public function setRepeatable($repeatable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($repeatable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($repeatable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($repeatable) && !is_string($repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($repeatable)), __LINE__);
        }
        $this->repeatable = $repeatable;
        return $this;
    }
    /**
     * Get intervalValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntervalValue()
    {
        return isset($this->intervalValue) ? $this->intervalValue : null;
    }
    /**
     * Set intervalValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intervalValue
     * @return UpdateLdapDirectoryReq
     */
    public function setIntervalValue($intervalValue = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($intervalValue)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $intervalValue, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($intervalValue) || (is_array($intervalValue) && empty($intervalValue))) {
            unset($this->intervalValue);
        } else {
            $this->intervalValue = $intervalValue;
        }
        return $this;
    }
    /**
     * Get scheduleUnit value
     * @return string|null
     */
    public function getScheduleUnit()
    {
        return $this->scheduleUnit;
    }
    /**
     * Set scheduleUnit value
     * @uses XScheduleUnit::valueIsValid()
     * @uses XScheduleUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduleUnit
     * @return UpdateLdapDirectoryReq
     */
    public function setScheduleUnit($scheduleUnit = 'DAY')
    {
        // validation for constraint: enumeration
        if (!XScheduleUnit::valueIsValid($scheduleUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scheduleUnit, implode(', ', XScheduleUnit::getValidValues())), __LINE__);
        }
        $this->scheduleUnit = $scheduleUnit;
        return $this;
    }
    /**
     * Get nextExecTime value
     * @return string|null
     */
    public function getNextExecTime()
    {
        return $this->nextExecTime;
    }
    /**
     * Set nextExecTime value
     * @param string $nextExecTime
     * @return UpdateLdapDirectoryReq
     */
    public function setNextExecTime($nextExecTime = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nextExecTime) && strlen($nextExecTime) > 32) || (is_array($nextExecTime) && count($nextExecTime) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($nextExecTime) ? strlen($nextExecTime) : count($nextExecTime)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nextExecTime) && !is_string($nextExecTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextExecTime)), __LINE__);
        }
        $this->nextExecTime = $nextExecTime;
        return $this;
    }
    /**
     * Get servers value
     * @return Servers|null
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param Servers $servers
     * @return UpdateLdapDirectoryReq
     */
    public function setServers(Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Get ldapFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getLdapFilter()
    {
        return isset($this->ldapFilter) ? $this->ldapFilter : null;
    }
    /**
     * Set ldapFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $ldapFilter
     * @return UpdateLdapDirectoryReq
     */
    public function setLdapFilter(XFkType $ldapFilter = null)
    {
        if (is_null($ldapFilter) || (is_array($ldapFilter) && empty($ldapFilter))) {
            unset($this->ldapFilter);
        } else {
            $this->ldapFilter = $ldapFilter;
        }
        return $this;
    }
    /**
     * Get removeAccessControlGroupInfo value
     * @return RemoveAccessControlGroupInfo|null
     */
    public function getRemoveAccessControlGroupInfo()
    {
        return $this->removeAccessControlGroupInfo;
    }
    /**
     * Set removeAccessControlGroupInfo value
     * @param RemoveAccessControlGroupInfo $removeAccessControlGroupInfo
     * @return UpdateLdapDirectoryReq
     */
    public function setRemoveAccessControlGroupInfo(RemoveAccessControlGroupInfo $removeAccessControlGroupInfo = null)
    {
        $this->removeAccessControlGroupInfo = $removeAccessControlGroupInfo;
        return $this;
    }
    /**
     * Get addAccessControlGroupInfo value
     * @return AddAccessControlGroupInfo|null
     */
    public function getAddAccessControlGroupInfo()
    {
        return $this->addAccessControlGroupInfo;
    }
    /**
     * Set addAccessControlGroupInfo value
     * @param AddAccessControlGroupInfo $addAccessControlGroupInfo
     * @return UpdateLdapDirectoryReq
     */
    public function setAddAccessControlGroupInfo(AddAccessControlGroupInfo $addAccessControlGroupInfo = null)
    {
        $this->addAccessControlGroupInfo = $addAccessControlGroupInfo;
        return $this;
    }
    /**
     * Get accessControlGroupInfo value
     * @return AccessControlGroupInfo|null
     */
    public function getAccessControlGroupInfo()
    {
        return $this->accessControlGroupInfo;
    }
    /**
     * Set accessControlGroupInfo value
     * @param AccessControlGroupInfo $accessControlGroupInfo
     * @return UpdateLdapDirectoryReq
     */
    public function setAccessControlGroupInfo(AccessControlGroupInfo $accessControlGroupInfo = null)
    {
        $this->accessControlGroupInfo = $accessControlGroupInfo;
        return $this;
    }
    /**
     * Get featureGroupTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getFeatureGroupTemplate()
    {
        return isset($this->featureGroupTemplate) ? $this->featureGroupTemplate : null;
    }
    /**
     * Set featureGroupTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $featureGroupTemplate
     * @return UpdateLdapDirectoryReq
     */
    public function setFeatureGroupTemplate(XFkType $featureGroupTemplate = null)
    {
        if (is_null($featureGroupTemplate) || (is_array($featureGroupTemplate) && empty($featureGroupTemplate))) {
            unset($this->featureGroupTemplate);
        } else {
            $this->featureGroupTemplate = $featureGroupTemplate;
        }
        return $this;
    }
    /**
     * Get applyMask value
     * @return string|null
     */
    public function getApplyMask()
    {
        return $this->applyMask;
    }
    /**
     * Set applyMask value
     * @param string $applyMask
     * @return UpdateLdapDirectoryReq
     */
    public function setApplyMask($applyMask = false)
    {
        // validation for constraint: pattern
        if (is_scalar($applyMask) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $applyMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($applyMask, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($applyMask) && !is_string($applyMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applyMask)), __LINE__);
        }
        $this->applyMask = $applyMask;
        return $this;
    }
    /**
     * Get mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMask()
    {
        return isset($this->mask) ? $this->mask : null;
    }
    /**
     * Set mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mask
     * @return UpdateLdapDirectoryReq
     */
    public function setMask($mask = null)
    {
        // validation for constraint: string
        if (!is_null($mask) && !is_string($mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mask)), __LINE__);
        }
        if (is_null($mask) || (is_array($mask) && empty($mask))) {
            unset($this->mask);
        } else {
            $this->mask = $mask;
        }
        return $this;
    }
    /**
     * Get applyPoolList value
     * @return string|null
     */
    public function getApplyPoolList()
    {
        return $this->applyPoolList;
    }
    /**
     * Set applyPoolList value
     * @param string $applyPoolList
     * @return UpdateLdapDirectoryReq
     */
    public function setApplyPoolList($applyPoolList = false)
    {
        // validation for constraint: pattern
        if (is_scalar($applyPoolList) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $applyPoolList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($applyPoolList, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($applyPoolList) && !is_string($applyPoolList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applyPoolList)), __LINE__);
        }
        $this->applyPoolList = $applyPoolList;
        return $this;
    }
    /**
     * Get addDns value
     * @return AddDns|null
     */
    public function getAddDns()
    {
        return $this->addDns;
    }
    /**
     * Set addDns value
     * @param AddDns $addDns
     * @return UpdateLdapDirectoryReq
     */
    public function setAddDns(AddDns $addDns = null)
    {
        $this->addDns = $addDns;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateLdapDirectoryReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
