<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCallPickupGroupReq StructType
 * @subpackage Structs
 */
class UpdateCallPickupGroupReq extends APIRequest
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The newPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newRoutePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $newRoutePartitionName;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The pickupNotification
     * Meta informations extracted from the WSDL
     * - default: No Alert
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pickupNotification;
    /**
     * The pickupNotificationTimer
     * Meta informations extracted from the WSDL
     * - default: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pickupNotificationTimer;
    /**
     * The callInfoForPickupNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CallInfoForPickupNotification
     */
    public $callInfoForPickupNotification;
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * Constructor method for UpdateCallPickupGroupReq
     * @uses UpdateCallPickupGroupReq::setName()
     * @uses UpdateCallPickupGroupReq::setPattern()
     * @uses UpdateCallPickupGroupReq::setUuid()
     * @uses UpdateCallPickupGroupReq::setRoutePartitionName()
     * @uses UpdateCallPickupGroupReq::setNewPattern()
     * @uses UpdateCallPickupGroupReq::setDescription()
     * @uses UpdateCallPickupGroupReq::setNewRoutePartitionName()
     * @uses UpdateCallPickupGroupReq::setRemoveMembers()
     * @uses UpdateCallPickupGroupReq::setAddMembers()
     * @uses UpdateCallPickupGroupReq::setMembers()
     * @uses UpdateCallPickupGroupReq::setPickupNotification()
     * @uses UpdateCallPickupGroupReq::setPickupNotificationTimer()
     * @uses UpdateCallPickupGroupReq::setCallInfoForPickupNotification()
     * @uses UpdateCallPickupGroupReq::setNewName()
     * @param string $name
     * @param string $pattern
     * @param string $uuid
     * @param XFkType $routePartitionName
     * @param string $newPattern
     * @param string $description
     * @param XFkType $newRoutePartitionName
     * @param RemoveMembers $removeMembers
     * @param AddMembers $addMembers
     * @param Members $members
     * @param string $pickupNotification
     * @param string $pickupNotificationTimer
     * @param CallInfoForPickupNotification $callInfoForPickupNotification
     * @param string $newName
     */
    public function __construct($name = null, $pattern = null, $uuid = null, XFkType $routePartitionName = null, $newPattern = null, $description = null, XFkType $newRoutePartitionName = null, RemoveMembers $removeMembers = null, AddMembers $addMembers = null, Members $members = null, $pickupNotification = 'No Alert', $pickupNotificationTimer = '6', CallInfoForPickupNotification $callInfoForPickupNotification = null, $newName = null)
    {
        $this
            ->setName($name)
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setRoutePartitionName($routePartitionName)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setNewRoutePartitionName($newRoutePartitionName)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setPickupNotification($pickupNotification)
            ->setPickupNotificationTimer($pickupNotificationTimer)
            ->setCallInfoForPickupNotification($callInfoForPickupNotification)
            ->setNewName($newName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return UpdateCallPickupGroupReq
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return UpdateCallPickupGroupReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return UpdateCallPickupGroupReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $routePartitionName
     * @return UpdateCallPickupGroupReq
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return UpdateCallPickupGroupReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateCallPickupGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newRoutePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNewRoutePartitionName()
    {
        return isset($this->newRoutePartitionName) ? $this->newRoutePartitionName : null;
    }
    /**
     * Set newRoutePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $newRoutePartitionName
     * @return UpdateCallPickupGroupReq
     */
    public function setNewRoutePartitionName(XFkType $newRoutePartitionName = null)
    {
        if (is_null($newRoutePartitionName) || (is_array($newRoutePartitionName) && empty($newRoutePartitionName))) {
            unset($this->newRoutePartitionName);
        } else {
            $this->newRoutePartitionName = $newRoutePartitionName;
        }
        return $this;
    }
    /**
     * Get removeMembers value
     * @return RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param RemoveMembers $removeMembers
     * @return UpdateCallPickupGroupReq
     */
    public function setRemoveMembers(RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param AddMembers $addMembers
     * @return UpdateCallPickupGroupReq
     */
    public function setAddMembers(AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return UpdateCallPickupGroupReq
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get pickupNotification value
     * @return string|null
     */
    public function getPickupNotification()
    {
        return $this->pickupNotification;
    }
    /**
     * Set pickupNotification value
     * @uses XPickupNotification::valueIsValid()
     * @uses XPickupNotification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupNotification
     * @return UpdateCallPickupGroupReq
     */
    public function setPickupNotification($pickupNotification = 'No Alert')
    {
        // validation for constraint: enumeration
        if (!XPickupNotification::valueIsValid($pickupNotification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pickupNotification, implode(', ', XPickupNotification::getValidValues())), __LINE__);
        }
        $this->pickupNotification = $pickupNotification;
        return $this;
    }
    /**
     * Get pickupNotificationTimer value
     * @return string|null
     */
    public function getPickupNotificationTimer()
    {
        return $this->pickupNotificationTimer;
    }
    /**
     * Set pickupNotificationTimer value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupNotificationTimer
     * @return UpdateCallPickupGroupReq
     */
    public function setPickupNotificationTimer($pickupNotificationTimer = '6')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($pickupNotificationTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pickupNotificationTimer, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->pickupNotificationTimer = $pickupNotificationTimer;
        return $this;
    }
    /**
     * Get callInfoForPickupNotification value
     * @return CallInfoForPickupNotification|null
     */
    public function getCallInfoForPickupNotification()
    {
        return $this->callInfoForPickupNotification;
    }
    /**
     * Set callInfoForPickupNotification value
     * @param CallInfoForPickupNotification $callInfoForPickupNotification
     * @return UpdateCallPickupGroupReq
     */
    public function setCallInfoForPickupNotification(CallInfoForPickupNotification $callInfoForPickupNotification = null)
    {
        $this->callInfoForPickupNotification = $callInfoForPickupNotification;
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateCallPickupGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateCallPickupGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
