<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCCAProfilesReq StructType
 * @subpackage Structs
 */
class UpdateCCAProfilesReq extends APIRequest
{
    /**
     * The ccaId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ccaId;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newCcaId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newCcaId;
    /**
     * The primarySoftSwitchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primarySoftSwitchId;
    /**
     * The secondarySoftSwitchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $secondarySoftSwitchId;
    /**
     * The objectClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $objectClass;
    /**
     * The subscriberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberType;
    /**
     * The sipAliasSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sipAliasSuffix;
    /**
     * The sipUserNameSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sipUserNameSuffix;
    /**
     * Constructor method for UpdateCCAProfilesReq
     * @uses UpdateCCAProfilesReq::setCcaId()
     * @uses UpdateCCAProfilesReq::setUuid()
     * @uses UpdateCCAProfilesReq::setNewCcaId()
     * @uses UpdateCCAProfilesReq::setPrimarySoftSwitchId()
     * @uses UpdateCCAProfilesReq::setSecondarySoftSwitchId()
     * @uses UpdateCCAProfilesReq::setObjectClass()
     * @uses UpdateCCAProfilesReq::setSubscriberType()
     * @uses UpdateCCAProfilesReq::setSipAliasSuffix()
     * @uses UpdateCCAProfilesReq::setSipUserNameSuffix()
     * @param string $ccaId
     * @param string $uuid
     * @param string $newCcaId
     * @param string $primarySoftSwitchId
     * @param string $secondarySoftSwitchId
     * @param string $objectClass
     * @param string $subscriberType
     * @param string $sipAliasSuffix
     * @param string $sipUserNameSuffix
     */
    public function __construct($ccaId = null, $uuid = null, $newCcaId = null, $primarySoftSwitchId = null, $secondarySoftSwitchId = null, $objectClass = null, $subscriberType = null, $sipAliasSuffix = null, $sipUserNameSuffix = null)
    {
        $this
            ->setCcaId($ccaId)
            ->setUuid($uuid)
            ->setNewCcaId($newCcaId)
            ->setPrimarySoftSwitchId($primarySoftSwitchId)
            ->setSecondarySoftSwitchId($secondarySoftSwitchId)
            ->setObjectClass($objectClass)
            ->setSubscriberType($subscriberType)
            ->setSipAliasSuffix($sipAliasSuffix)
            ->setSipUserNameSuffix($sipUserNameSuffix);
    }
    /**
     * Get ccaId value
     * @return string
     */
    public function getCcaId()
    {
        return $this->ccaId;
    }
    /**
     * Set ccaId value
     * @param string $ccaId
     * @return UpdateCCAProfilesReq
     */
    public function setCcaId($ccaId = null)
    {
        // validation for constraint: string
        if (!is_null($ccaId) && !is_string($ccaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ccaId)), __LINE__);
        }
        $this->ccaId = $ccaId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return UpdateCCAProfilesReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newCcaId value
     * @return string|null
     */
    public function getNewCcaId()
    {
        return $this->newCcaId;
    }
    /**
     * Set newCcaId value
     * @param string $newCcaId
     * @return UpdateCCAProfilesReq
     */
    public function setNewCcaId($newCcaId = null)
    {
        // validation for constraint: string
        if (!is_null($newCcaId) && !is_string($newCcaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newCcaId)), __LINE__);
        }
        $this->newCcaId = $newCcaId;
        return $this;
    }
    /**
     * Get primarySoftSwitchId value
     * @return string|null
     */
    public function getPrimarySoftSwitchId()
    {
        return $this->primarySoftSwitchId;
    }
    /**
     * Set primarySoftSwitchId value
     * @param string $primarySoftSwitchId
     * @return UpdateCCAProfilesReq
     */
    public function setPrimarySoftSwitchId($primarySoftSwitchId = null)
    {
        // validation for constraint: string
        if (!is_null($primarySoftSwitchId) && !is_string($primarySoftSwitchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primarySoftSwitchId)), __LINE__);
        }
        $this->primarySoftSwitchId = $primarySoftSwitchId;
        return $this;
    }
    /**
     * Get secondarySoftSwitchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondarySoftSwitchId()
    {
        return isset($this->secondarySoftSwitchId) ? $this->secondarySoftSwitchId : null;
    }
    /**
     * Set secondarySoftSwitchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondarySoftSwitchId
     * @return UpdateCCAProfilesReq
     */
    public function setSecondarySoftSwitchId($secondarySoftSwitchId = null)
    {
        // validation for constraint: string
        if (!is_null($secondarySoftSwitchId) && !is_string($secondarySoftSwitchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondarySoftSwitchId)), __LINE__);
        }
        if (is_null($secondarySoftSwitchId) || (is_array($secondarySoftSwitchId) && empty($secondarySoftSwitchId))) {
            unset($this->secondarySoftSwitchId);
        } else {
            $this->secondarySoftSwitchId = $secondarySoftSwitchId;
        }
        return $this;
    }
    /**
     * Get objectClass value
     * @return string|null
     */
    public function getObjectClass()
    {
        return $this->objectClass;
    }
    /**
     * Set objectClass value
     * @param string $objectClass
     * @return UpdateCCAProfilesReq
     */
    public function setObjectClass($objectClass = null)
    {
        // validation for constraint: string
        if (!is_null($objectClass) && !is_string($objectClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectClass)), __LINE__);
        }
        $this->objectClass = $objectClass;
        return $this;
    }
    /**
     * Get subscriberType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberType()
    {
        return isset($this->subscriberType) ? $this->subscriberType : null;
    }
    /**
     * Set subscriberType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberType
     * @return UpdateCCAProfilesReq
     */
    public function setSubscriberType($subscriberType = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberType) && !is_string($subscriberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberType)), __LINE__);
        }
        if (is_null($subscriberType) || (is_array($subscriberType) && empty($subscriberType))) {
            unset($this->subscriberType);
        } else {
            $this->subscriberType = $subscriberType;
        }
        return $this;
    }
    /**
     * Get sipAliasSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSipAliasSuffix()
    {
        return isset($this->sipAliasSuffix) ? $this->sipAliasSuffix : null;
    }
    /**
     * Set sipAliasSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sipAliasSuffix
     * @return UpdateCCAProfilesReq
     */
    public function setSipAliasSuffix($sipAliasSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sipAliasSuffix) && !is_string($sipAliasSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sipAliasSuffix)), __LINE__);
        }
        if (is_null($sipAliasSuffix) || (is_array($sipAliasSuffix) && empty($sipAliasSuffix))) {
            unset($this->sipAliasSuffix);
        } else {
            $this->sipAliasSuffix = $sipAliasSuffix;
        }
        return $this;
    }
    /**
     * Get sipUserNameSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSipUserNameSuffix()
    {
        return isset($this->sipUserNameSuffix) ? $this->sipUserNameSuffix : null;
    }
    /**
     * Set sipUserNameSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sipUserNameSuffix
     * @return UpdateCCAProfilesReq
     */
    public function setSipUserNameSuffix($sipUserNameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sipUserNameSuffix) && !is_string($sipUserNameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sipUserNameSuffix)), __LINE__);
        }
        if (is_null($sipUserNameSuffix) || (is_array($sipUserNameSuffix) && empty($sipUserNameSuffix))) {
            unset($this->sipUserNameSuffix);
        } else {
            $this->sipUserNameSuffix = $sipUserNameSuffix;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateCCAProfilesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
