<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeAssociatedTrunks StructType
 * @subpackage Structs
 */
class RemoveAssociatedTrunks extends XCommonMembersExtension
{
    /**
     * The associatedTrunk
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var XCcdRequestingServiceMember[]
     */
    public $associatedTrunk;
    /**
     * Constructor method for removeAssociatedTrunks
     * @uses RemoveAssociatedTrunks::setAssociatedTrunk()
     * @param XCcdRequestingServiceMember[] $associatedTrunk
     */
    public function __construct(array $associatedTrunk = array())
    {
        $this
            ->setAssociatedTrunk($associatedTrunk);
    }
    /**
     * Get associatedTrunk value
     * @return XCcdRequestingServiceMember[]
     */
    public function getAssociatedTrunk()
    {
        return $this->associatedTrunk;
    }
    /**
     * Set associatedTrunk value
     * @throws \InvalidArgumentException
     * @param XCcdRequestingServiceMember[] $associatedTrunk
     * @return RemoveAssociatedTrunks
     */
    public function setAssociatedTrunk(array $associatedTrunk = array())
    {
        foreach ($associatedTrunk as $removeAssociatedTrunksAssociatedTrunkItem) {
            // validation for constraint: itemType
            if (!$removeAssociatedTrunksAssociatedTrunkItem instanceof XCcdRequestingServiceMember) {
                throw new \InvalidArgumentException(sprintf('The associatedTrunk property can only contain items of XCcdRequestingServiceMember, "%s" given', is_object($removeAssociatedTrunksAssociatedTrunkItem) ? get_class($removeAssociatedTrunksAssociatedTrunkItem) : gettype($removeAssociatedTrunksAssociatedTrunkItem)), __LINE__);
            }
        }
        $this->associatedTrunk = $associatedTrunk;
        return $this;
    }
    /**
     * Add item to associatedTrunk value
     * @throws \InvalidArgumentException
     * @param XCcdRequestingServiceMember $item
     * @return RemoveAssociatedTrunks
     */
    public function addToAssociatedTrunk(XCcdRequestingServiceMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof XCcdRequestingServiceMember) {
            throw new \InvalidArgumentException(sprintf('The associatedTrunk property can only contain items of XCcdRequestingServiceMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->associatedTrunk[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RemoveAssociatedTrunks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
