<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedLocations StructType
 * @subpackage Structs
 */
class RelatedLocations extends AbstractStructBase
{
    /**
     * The relatedLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var XLocationRelationship[]
     */
    public $relatedLocation;
    /**
     * Constructor method for relatedLocations
     * @uses RelatedLocations::setRelatedLocation()
     * @param XLocationRelationship[] $relatedLocation
     */
    public function __construct(array $relatedLocation = array())
    {
        $this
            ->setRelatedLocation($relatedLocation);
    }
    /**
     * Get relatedLocation value
     * @return XLocationRelationship[]|null
     */
    public function getRelatedLocation()
    {
        return $this->relatedLocation;
    }
    /**
     * Set relatedLocation value
     * @throws \InvalidArgumentException
     * @param XLocationRelationship[] $relatedLocation
     * @return RelatedLocations
     */
    public function setRelatedLocation(array $relatedLocation = array())
    {
        foreach ($relatedLocation as $relatedLocationsRelatedLocationItem) {
            // validation for constraint: itemType
            if (!$relatedLocationsRelatedLocationItem instanceof XLocationRelationship) {
                throw new \InvalidArgumentException(sprintf('The relatedLocation property can only contain items of XLocationRelationship, "%s" given', is_object($relatedLocationsRelatedLocationItem) ? get_class($relatedLocationsRelatedLocationItem) : gettype($relatedLocationsRelatedLocationItem)), __LINE__);
            }
        }
        $this->relatedLocation = $relatedLocation;
        return $this;
    }
    /**
     * Add item to relatedLocation value
     * @throws \InvalidArgumentException
     * @param XLocationRelationship $item
     * @return RelatedLocations
     */
    public function addToRelatedLocation(XLocationRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof XLocationRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedLocation property can only contain items of XLocationRelationship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relatedLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RelatedLocations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
