<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RWifiHotspot StructType
 * @subpackage Structs
 */
class RWifiHotspot extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The ssidPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ssidPrefix;
    /**
     * The userModifiable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userModifiable;
    /**
     * The frequencyBand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $frequencyBand;
    /**
     * The authenticationMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMethod;
    /**
     * The hostName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 64
     * @var string
     */
    public $hostName;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The sharedSecret
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sharedSecret;
    /**
     * The pskPassPhrase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pskPassPhrase;
    /**
     * The wepKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $wepKey;
    /**
     * The passwordDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $passwordDescription;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RWifiHotspot
     * @uses RWifiHotspot::setName()
     * @uses RWifiHotspot::setDescription()
     * @uses RWifiHotspot::setSsidPrefix()
     * @uses RWifiHotspot::setUserModifiable()
     * @uses RWifiHotspot::setFrequencyBand()
     * @uses RWifiHotspot::setAuthenticationMethod()
     * @uses RWifiHotspot::setHostName()
     * @uses RWifiHotspot::setPort()
     * @uses RWifiHotspot::setSharedSecret()
     * @uses RWifiHotspot::setPskPassPhrase()
     * @uses RWifiHotspot::setWepKey()
     * @uses RWifiHotspot::setPasswordDescription()
     * @uses RWifiHotspot::setUuid()
     * @param string $name
     * @param string $description
     * @param string $ssidPrefix
     * @param string $userModifiable
     * @param string $frequencyBand
     * @param string $authenticationMethod
     * @param string $hostName
     * @param string $port
     * @param string $sharedSecret
     * @param string $pskPassPhrase
     * @param string $wepKey
     * @param string $passwordDescription
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $ssidPrefix = null, $userModifiable = null, $frequencyBand = null, $authenticationMethod = null, $hostName = null, $port = null, $sharedSecret = null, $pskPassPhrase = null, $wepKey = null, $passwordDescription = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setSsidPrefix($ssidPrefix)
            ->setUserModifiable($userModifiable)
            ->setFrequencyBand($frequencyBand)
            ->setAuthenticationMethod($authenticationMethod)
            ->setHostName($hostName)
            ->setPort($port)
            ->setSharedSecret($sharedSecret)
            ->setPskPassPhrase($pskPassPhrase)
            ->setWepKey($wepKey)
            ->setPasswordDescription($passwordDescription)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RWifiHotspot
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RWifiHotspot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ssidPrefix value
     * @return string|null
     */
    public function getSsidPrefix()
    {
        return $this->ssidPrefix;
    }
    /**
     * Set ssidPrefix value
     * @param string $ssidPrefix
     * @return RWifiHotspot
     */
    public function setSsidPrefix($ssidPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($ssidPrefix) && !is_string($ssidPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssidPrefix)), __LINE__);
        }
        $this->ssidPrefix = $ssidPrefix;
        return $this;
    }
    /**
     * Get userModifiable value
     * @return string|null
     */
    public function getUserModifiable()
    {
        return $this->userModifiable;
    }
    /**
     * Set userModifiable value
     * @uses XWLANProfileChanges::valueIsValid()
     * @uses XWLANProfileChanges::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userModifiable
     * @return RWifiHotspot
     */
    public function setUserModifiable($userModifiable = null)
    {
        // validation for constraint: enumeration
        if (!XWLANProfileChanges::valueIsValid($userModifiable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userModifiable, implode(', ', XWLANProfileChanges::getValidValues())), __LINE__);
        }
        $this->userModifiable = $userModifiable;
        return $this;
    }
    /**
     * Get frequencyBand value
     * @return string|null
     */
    public function getFrequencyBand()
    {
        return $this->frequencyBand;
    }
    /**
     * Set frequencyBand value
     * @uses XWiFiFrequency::valueIsValid()
     * @uses XWiFiFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequencyBand
     * @return RWifiHotspot
     */
    public function setFrequencyBand($frequencyBand = null)
    {
        // validation for constraint: enumeration
        if (!XWiFiFrequency::valueIsValid($frequencyBand)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $frequencyBand, implode(', ', XWiFiFrequency::getValidValues())), __LINE__);
        }
        $this->frequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get authenticationMethod value
     * @return string|null
     */
    public function getAuthenticationMethod()
    {
        return $this->authenticationMethod;
    }
    /**
     * Set authenticationMethod value
     * @uses XHotspotAuthenticationMethod::valueIsValid()
     * @uses XHotspotAuthenticationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMethod
     * @return RWifiHotspot
     */
    public function setAuthenticationMethod($authenticationMethod = null)
    {
        // validation for constraint: enumeration
        if (!XHotspotAuthenticationMethod::valueIsValid($authenticationMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMethod, implode(', ', XHotspotAuthenticationMethod::getValidValues())), __LINE__);
        }
        $this->authenticationMethod = $authenticationMethod;
        return $this;
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return RWifiHotspot
     */
    public function setHostName($hostName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hostName) && strlen($hostName) > 64) || (is_array($hostName) && count($hostName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($hostName) ? strlen($hostName) : count($hostName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hostName) && !is_string($hostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostName)), __LINE__);
        }
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return RWifiHotspot
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get sharedSecret value
     * @return string|null
     */
    public function getSharedSecret()
    {
        return $this->sharedSecret;
    }
    /**
     * Set sharedSecret value
     * @param string $sharedSecret
     * @return RWifiHotspot
     */
    public function setSharedSecret($sharedSecret = null)
    {
        // validation for constraint: string
        if (!is_null($sharedSecret) && !is_string($sharedSecret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sharedSecret)), __LINE__);
        }
        $this->sharedSecret = $sharedSecret;
        return $this;
    }
    /**
     * Get pskPassPhrase value
     * @return string|null
     */
    public function getPskPassPhrase()
    {
        return $this->pskPassPhrase;
    }
    /**
     * Set pskPassPhrase value
     * @param string $pskPassPhrase
     * @return RWifiHotspot
     */
    public function setPskPassPhrase($pskPassPhrase = null)
    {
        // validation for constraint: string
        if (!is_null($pskPassPhrase) && !is_string($pskPassPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pskPassPhrase)), __LINE__);
        }
        $this->pskPassPhrase = $pskPassPhrase;
        return $this;
    }
    /**
     * Get wepKey value
     * @return string|null
     */
    public function getWepKey()
    {
        return $this->wepKey;
    }
    /**
     * Set wepKey value
     * @param string $wepKey
     * @return RWifiHotspot
     */
    public function setWepKey($wepKey = null)
    {
        // validation for constraint: string
        if (!is_null($wepKey) && !is_string($wepKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wepKey)), __LINE__);
        }
        $this->wepKey = $wepKey;
        return $this;
    }
    /**
     * Get passwordDescription value
     * @return string|null
     */
    public function getPasswordDescription()
    {
        return $this->passwordDescription;
    }
    /**
     * Set passwordDescription value
     * @param string $passwordDescription
     * @return RWifiHotspot
     */
    public function setPasswordDescription($passwordDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($passwordDescription) && strlen($passwordDescription) > 255) || (is_array($passwordDescription) && count($passwordDescription) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($passwordDescription) ? strlen($passwordDescription) : count($passwordDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($passwordDescription) && !is_string($passwordDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordDescription)), __LINE__);
        }
        $this->passwordDescription = $passwordDescription;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RWifiHotspot
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RWifiHotspot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
