<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RVohServer StructType
 * @subpackage Structs
 */
class RVohServer extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The sipTrunkName
     * Meta informations extracted from the WSDL
     * - documentation: SIP Trunk for Video On Hold Server
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $sipTrunkName;
    /**
     * The defaultVideoStreamId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $defaultVideoStreamId;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RVohServer
     * @uses RVohServer::setName()
     * @uses RVohServer::setDescription()
     * @uses RVohServer::setSipTrunkName()
     * @uses RVohServer::setDefaultVideoStreamId()
     * @uses RVohServer::setUuid()
     * @param string $name
     * @param string $description
     * @param XFkType $sipTrunkName
     * @param string $defaultVideoStreamId
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, XFkType $sipTrunkName = null, $defaultVideoStreamId = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setSipTrunkName($sipTrunkName)
            ->setDefaultVideoStreamId($defaultVideoStreamId)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RVohServer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RVohServer
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param XFkType $sipTrunkName
     * @return RVohServer
     */
    public function setSipTrunkName(XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get defaultVideoStreamId value
     * @return string|null
     */
    public function getDefaultVideoStreamId()
    {
        return $this->defaultVideoStreamId;
    }
    /**
     * Set defaultVideoStreamId value
     * @param string $defaultVideoStreamId
     * @return RVohServer
     */
    public function setDefaultVideoStreamId($defaultVideoStreamId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultVideoStreamId) && !is_string($defaultVideoStreamId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultVideoStreamId)), __LINE__);
        }
        $this->defaultVideoStreamId = $defaultVideoStreamId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RVohServer
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RVohServer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
