<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RUserProfileProvision StructType
 * @subpackage Structs
 */
class RUserProfileProvision extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The deskPhones
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $deskPhones;
    /**
     * The mobileDevices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mobileDevices;
    /**
     * The profile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $profile;
    /**
     * The universalLineTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $universalLineTemplate;
    /**
     * The allowProvision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowProvision;
    /**
     * The limitProvision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $limitProvision;
    /**
     * The defaultUserProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $defaultUserProfile;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RUserProfileProvision
     * @uses RUserProfileProvision::setName()
     * @uses RUserProfileProvision::setDescription()
     * @uses RUserProfileProvision::setDeskPhones()
     * @uses RUserProfileProvision::setMobileDevices()
     * @uses RUserProfileProvision::setProfile()
     * @uses RUserProfileProvision::setUniversalLineTemplate()
     * @uses RUserProfileProvision::setAllowProvision()
     * @uses RUserProfileProvision::setLimitProvision()
     * @uses RUserProfileProvision::setDefaultUserProfile()
     * @uses RUserProfileProvision::setUuid()
     * @param string $name
     * @param string $description
     * @param XFkType $deskPhones
     * @param XFkType $mobileDevices
     * @param XFkType $profile
     * @param XFkType $universalLineTemplate
     * @param string $allowProvision
     * @param string $limitProvision
     * @param XFkType $defaultUserProfile
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, XFkType $deskPhones = null, XFkType $mobileDevices = null, XFkType $profile = null, XFkType $universalLineTemplate = null, $allowProvision = null, $limitProvision = null, XFkType $defaultUserProfile = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDeskPhones($deskPhones)
            ->setMobileDevices($mobileDevices)
            ->setProfile($profile)
            ->setUniversalLineTemplate($universalLineTemplate)
            ->setAllowProvision($allowProvision)
            ->setLimitProvision($limitProvision)
            ->setDefaultUserProfile($defaultUserProfile)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RUserProfileProvision
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RUserProfileProvision
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get deskPhones value
     * @return XFkType|null
     */
    public function getDeskPhones()
    {
        return $this->deskPhones;
    }
    /**
     * Set deskPhones value
     * @param XFkType $deskPhones
     * @return RUserProfileProvision
     */
    public function setDeskPhones(XFkType $deskPhones = null)
    {
        $this->deskPhones = $deskPhones;
        return $this;
    }
    /**
     * Get mobileDevices value
     * @return XFkType|null
     */
    public function getMobileDevices()
    {
        return $this->mobileDevices;
    }
    /**
     * Set mobileDevices value
     * @param XFkType $mobileDevices
     * @return RUserProfileProvision
     */
    public function setMobileDevices(XFkType $mobileDevices = null)
    {
        $this->mobileDevices = $mobileDevices;
        return $this;
    }
    /**
     * Get profile value
     * @return XFkType|null
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @param XFkType $profile
     * @return RUserProfileProvision
     */
    public function setProfile(XFkType $profile = null)
    {
        $this->profile = $profile;
        return $this;
    }
    /**
     * Get universalLineTemplate value
     * @return XFkType|null
     */
    public function getUniversalLineTemplate()
    {
        return $this->universalLineTemplate;
    }
    /**
     * Set universalLineTemplate value
     * @param XFkType $universalLineTemplate
     * @return RUserProfileProvision
     */
    public function setUniversalLineTemplate(XFkType $universalLineTemplate = null)
    {
        $this->universalLineTemplate = $universalLineTemplate;
        return $this;
    }
    /**
     * Get allowProvision value
     * @return string|null
     */
    public function getAllowProvision()
    {
        return $this->allowProvision;
    }
    /**
     * Set allowProvision value
     * @param string $allowProvision
     * @return RUserProfileProvision
     */
    public function setAllowProvision($allowProvision = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowProvision) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowProvision, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowProvision) && !is_string($allowProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowProvision)), __LINE__);
        }
        $this->allowProvision = $allowProvision;
        return $this;
    }
    /**
     * Get limitProvision value
     * @return string|null
     */
    public function getLimitProvision()
    {
        return $this->limitProvision;
    }
    /**
     * Set limitProvision value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitProvision
     * @return RUserProfileProvision
     */
    public function setLimitProvision($limitProvision = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($limitProvision)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $limitProvision, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->limitProvision = $limitProvision;
        return $this;
    }
    /**
     * Get defaultUserProfile value
     * @return XFkType|null
     */
    public function getDefaultUserProfile()
    {
        return $this->defaultUserProfile;
    }
    /**
     * Set defaultUserProfile value
     * @param XFkType $defaultUserProfile
     * @return RUserProfileProvision
     */
    public function setDefaultUserProfile(XFkType $defaultUserProfile = null)
    {
        $this->defaultUserProfile = $defaultUserProfile;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RUserProfileProvision
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RUserProfileProvision
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
