<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RMtp StructType
 * @subpackage Structs
 */
class RMtp extends AbstractStructBase
{
    /**
     * The mtpType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mtpType;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The trustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $trustedRelayPoint;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RMtp
     * @uses RMtp::setMtpType()
     * @uses RMtp::setName()
     * @uses RMtp::setDescription()
     * @uses RMtp::setDevicePoolName()
     * @uses RMtp::setTrustedRelayPoint()
     * @uses RMtp::setUuid()
     * @param string $mtpType
     * @param string $name
     * @param string $description
     * @param XFkType $devicePoolName
     * @param string $trustedRelayPoint
     * @param string $uuid
     */
    public function __construct($mtpType = null, $name = null, $description = null, XFkType $devicePoolName = null, $trustedRelayPoint = null, $uuid = null)
    {
        $this
            ->setMtpType($mtpType)
            ->setName($name)
            ->setDescription($description)
            ->setDevicePoolName($devicePoolName)
            ->setTrustedRelayPoint($trustedRelayPoint)
            ->setUuid($uuid);
    }
    /**
     * Get mtpType value
     * @return string|null
     */
    public function getMtpType()
    {
        return $this->mtpType;
    }
    /**
     * Set mtpType value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpType
     * @return RMtp
     */
    public function setMtpType($mtpType = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($mtpType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mtpType, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->mtpType = $mtpType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RMtp
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RMtp
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return RMtp
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get trustedRelayPoint value
     * @return string|null
     */
    public function getTrustedRelayPoint()
    {
        return $this->trustedRelayPoint;
    }
    /**
     * Set trustedRelayPoint value
     * @param string $trustedRelayPoint
     * @return RMtp
     */
    public function setTrustedRelayPoint($trustedRelayPoint = null)
    {
        // validation for constraint: pattern
        if (is_scalar($trustedRelayPoint) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $trustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($trustedRelayPoint, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($trustedRelayPoint) && !is_string($trustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trustedRelayPoint)), __LINE__);
        }
        $this->trustedRelayPoint = $trustedRelayPoint;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RMtp
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RMtp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
