<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RMediaResourceList StructType
 * @subpackage Structs
 */
class RMediaResourceList extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The clause
     * Meta informations extracted from the WSDL
     * - documentation: Read only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $clause;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RMediaResourceList
     * @uses RMediaResourceList::setName()
     * @uses RMediaResourceList::setClause()
     * @uses RMediaResourceList::setMembers()
     * @uses RMediaResourceList::setUuid()
     * @param string $name
     * @param string $clause
     * @param Members $members
     * @param string $uuid
     */
    public function __construct($name = null, $clause = null, Members $members = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setClause($clause)
            ->setMembers($members)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RMediaResourceList
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get clause value
     * @return string|null
     */
    public function getClause()
    {
        return $this->clause;
    }
    /**
     * Set clause value
     * @param string $clause
     * @return RMediaResourceList
     */
    public function setClause($clause = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clause) && strlen($clause) > 1024) || (is_array($clause) && count($clause) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($clause) ? strlen($clause) : count($clause)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clause) && !is_string($clause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clause)), __LINE__);
        }
        $this->clause = $clause;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return RMediaResourceList
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RMediaResourceList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RMediaResourceList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
