<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RGatekeeper StructType
 * @subpackage Structs
 */
class RGatekeeper extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: From Device Table
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: From Device Table
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The rrqTimeToLive
     * Meta informations extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rrqTimeToLive;
    /**
     * The retryTimeout
     * Meta informations extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryTimeout;
    /**
     * The enableDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDevice;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RGatekeeper
     * @uses RGatekeeper::setName()
     * @uses RGatekeeper::setDescription()
     * @uses RGatekeeper::setRrqTimeToLive()
     * @uses RGatekeeper::setRetryTimeout()
     * @uses RGatekeeper::setEnableDevice()
     * @uses RGatekeeper::setUuid()
     * @param string $name
     * @param string $description
     * @param string $rrqTimeToLive
     * @param string $retryTimeout
     * @param string $enableDevice
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $rrqTimeToLive = null, $retryTimeout = null, $enableDevice = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setRrqTimeToLive($rrqTimeToLive)
            ->setRetryTimeout($retryTimeout)
            ->setEnableDevice($enableDevice)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RGatekeeper
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RGatekeeper
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get rrqTimeToLive value
     * @return string|null
     */
    public function getRrqTimeToLive()
    {
        return $this->rrqTimeToLive;
    }
    /**
     * Set rrqTimeToLive value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rrqTimeToLive
     * @return RGatekeeper
     */
    public function setRrqTimeToLive($rrqTimeToLive = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($rrqTimeToLive)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rrqTimeToLive, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->rrqTimeToLive = $rrqTimeToLive;
        return $this;
    }
    /**
     * Get retryTimeout value
     * @return string|null
     */
    public function getRetryTimeout()
    {
        return $this->retryTimeout;
    }
    /**
     * Set retryTimeout value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryTimeout
     * @return RGatekeeper
     */
    public function setRetryTimeout($retryTimeout = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($retryTimeout)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retryTimeout, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->retryTimeout = $retryTimeout;
        return $this;
    }
    /**
     * Get enableDevice value
     * @return string|null
     */
    public function getEnableDevice()
    {
        return $this->enableDevice;
    }
    /**
     * Set enableDevice value
     * @param string $enableDevice
     * @return RGatekeeper
     */
    public function setEnableDevice($enableDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableDevice) && !is_string($enableDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableDevice)), __LINE__);
        }
        $this->enableDevice = $enableDevice;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RGatekeeper
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RGatekeeper
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
