<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFeatureGroupTemplate StructType
 * @subpackage Structs
 */
class RFeatureGroupTemplate extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The homeCluster
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $homeCluster;
    /**
     * The imAndUcPresenceEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $imAndUcPresenceEnable;
    /**
     * The serviceProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $serviceProfile;
    /**
     * The allowCTIControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCTIControl;
    /**
     * The enableEMCC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableEMCC;
    /**
     * The enableMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobility;
    /**
     * The enableMobileVoiceAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileVoiceAccess;
    /**
     * The maxDeskPickupWait
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxDeskPickupWait;
    /**
     * The remoteDestinationLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteDestinationLimit;
    /**
     * The BLFPresenceGp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $BLFPresenceGp;
    /**
     * The subscribeCallingSearch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $subscribeCallingSearch;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The userProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $userProfile;
    /**
     * The meetingInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $meetingInformation;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RFeatureGroupTemplate
     * @uses RFeatureGroupTemplate::setName()
     * @uses RFeatureGroupTemplate::setDescription()
     * @uses RFeatureGroupTemplate::setHomeCluster()
     * @uses RFeatureGroupTemplate::setImAndUcPresenceEnable()
     * @uses RFeatureGroupTemplate::setServiceProfile()
     * @uses RFeatureGroupTemplate::setAllowCTIControl()
     * @uses RFeatureGroupTemplate::setEnableEMCC()
     * @uses RFeatureGroupTemplate::setEnableMobility()
     * @uses RFeatureGroupTemplate::setEnableMobileVoiceAccess()
     * @uses RFeatureGroupTemplate::setMaxDeskPickupWait()
     * @uses RFeatureGroupTemplate::setRemoteDestinationLimit()
     * @uses RFeatureGroupTemplate::setBLFPresenceGp()
     * @uses RFeatureGroupTemplate::setSubscribeCallingSearch()
     * @uses RFeatureGroupTemplate::setUserLocale()
     * @uses RFeatureGroupTemplate::setUserProfile()
     * @uses RFeatureGroupTemplate::setMeetingInformation()
     * @uses RFeatureGroupTemplate::setUuid()
     * @param string $name
     * @param string $description
     * @param string $homeCluster
     * @param string $imAndUcPresenceEnable
     * @param XFkType $serviceProfile
     * @param string $allowCTIControl
     * @param string $enableEMCC
     * @param string $enableMobility
     * @param string $enableMobileVoiceAccess
     * @param string $maxDeskPickupWait
     * @param string $remoteDestinationLimit
     * @param XFkType $bLFPresenceGp
     * @param XFkType $subscribeCallingSearch
     * @param string $userLocale
     * @param XFkType $userProfile
     * @param string $meetingInformation
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $homeCluster = null, $imAndUcPresenceEnable = null, XFkType $serviceProfile = null, $allowCTIControl = null, $enableEMCC = null, $enableMobility = null, $enableMobileVoiceAccess = null, $maxDeskPickupWait = null, $remoteDestinationLimit = null, XFkType $bLFPresenceGp = null, XFkType $subscribeCallingSearch = null, $userLocale = null, XFkType $userProfile = null, $meetingInformation = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setHomeCluster($homeCluster)
            ->setImAndUcPresenceEnable($imAndUcPresenceEnable)
            ->setServiceProfile($serviceProfile)
            ->setAllowCTIControl($allowCTIControl)
            ->setEnableEMCC($enableEMCC)
            ->setEnableMobility($enableMobility)
            ->setEnableMobileVoiceAccess($enableMobileVoiceAccess)
            ->setMaxDeskPickupWait($maxDeskPickupWait)
            ->setRemoteDestinationLimit($remoteDestinationLimit)
            ->setBLFPresenceGp($bLFPresenceGp)
            ->setSubscribeCallingSearch($subscribeCallingSearch)
            ->setUserLocale($userLocale)
            ->setUserProfile($userProfile)
            ->setMeetingInformation($meetingInformation)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RFeatureGroupTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RFeatureGroupTemplate
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get homeCluster value
     * @return string|null
     */
    public function getHomeCluster()
    {
        return $this->homeCluster;
    }
    /**
     * Set homeCluster value
     * @param string $homeCluster
     * @return RFeatureGroupTemplate
     */
    public function setHomeCluster($homeCluster = null)
    {
        // validation for constraint: pattern
        if (is_scalar($homeCluster) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($homeCluster, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($homeCluster) && !is_string($homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homeCluster)), __LINE__);
        }
        $this->homeCluster = $homeCluster;
        return $this;
    }
    /**
     * Get imAndUcPresenceEnable value
     * @return string|null
     */
    public function getImAndUcPresenceEnable()
    {
        return $this->imAndUcPresenceEnable;
    }
    /**
     * Set imAndUcPresenceEnable value
     * @param string $imAndUcPresenceEnable
     * @return RFeatureGroupTemplate
     */
    public function setImAndUcPresenceEnable($imAndUcPresenceEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($imAndUcPresenceEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $imAndUcPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($imAndUcPresenceEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($imAndUcPresenceEnable) && !is_string($imAndUcPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imAndUcPresenceEnable)), __LINE__);
        }
        $this->imAndUcPresenceEnable = $imAndUcPresenceEnable;
        return $this;
    }
    /**
     * Get serviceProfile value
     * @return XFkType|null
     */
    public function getServiceProfile()
    {
        return $this->serviceProfile;
    }
    /**
     * Set serviceProfile value
     * @param XFkType $serviceProfile
     * @return RFeatureGroupTemplate
     */
    public function setServiceProfile(XFkType $serviceProfile = null)
    {
        $this->serviceProfile = $serviceProfile;
        return $this;
    }
    /**
     * Get allowCTIControl value
     * @return string|null
     */
    public function getAllowCTIControl()
    {
        return $this->allowCTIControl;
    }
    /**
     * Set allowCTIControl value
     * @param string $allowCTIControl
     * @return RFeatureGroupTemplate
     */
    public function setAllowCTIControl($allowCTIControl = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowCTIControl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowCTIControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowCTIControl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowCTIControl) && !is_string($allowCTIControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowCTIControl)), __LINE__);
        }
        $this->allowCTIControl = $allowCTIControl;
        return $this;
    }
    /**
     * Get enableEMCC value
     * @return string|null
     */
    public function getEnableEMCC()
    {
        return $this->enableEMCC;
    }
    /**
     * Set enableEMCC value
     * @param string $enableEMCC
     * @return RFeatureGroupTemplate
     */
    public function setEnableEMCC($enableEMCC = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableEMCC) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableEMCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableEMCC, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableEMCC) && !is_string($enableEMCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableEMCC)), __LINE__);
        }
        $this->enableEMCC = $enableEMCC;
        return $this;
    }
    /**
     * Get enableMobility value
     * @return string|null
     */
    public function getEnableMobility()
    {
        return $this->enableMobility;
    }
    /**
     * Set enableMobility value
     * @param string $enableMobility
     * @return RFeatureGroupTemplate
     */
    public function setEnableMobility($enableMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobility) && !is_string($enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobility)), __LINE__);
        }
        $this->enableMobility = $enableMobility;
        return $this;
    }
    /**
     * Get enableMobileVoiceAccess value
     * @return string|null
     */
    public function getEnableMobileVoiceAccess()
    {
        return $this->enableMobileVoiceAccess;
    }
    /**
     * Set enableMobileVoiceAccess value
     * @param string $enableMobileVoiceAccess
     * @return RFeatureGroupTemplate
     */
    public function setEnableMobileVoiceAccess($enableMobileVoiceAccess = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobileVoiceAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobileVoiceAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobileVoiceAccess) && !is_string($enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobileVoiceAccess)), __LINE__);
        }
        $this->enableMobileVoiceAccess = $enableMobileVoiceAccess;
        return $this;
    }
    /**
     * Get maxDeskPickupWait value
     * @return string|null
     */
    public function getMaxDeskPickupWait()
    {
        return $this->maxDeskPickupWait;
    }
    /**
     * Set maxDeskPickupWait value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxDeskPickupWait
     * @return RFeatureGroupTemplate
     */
    public function setMaxDeskPickupWait($maxDeskPickupWait = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxDeskPickupWait)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxDeskPickupWait, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxDeskPickupWait = $maxDeskPickupWait;
        return $this;
    }
    /**
     * Get remoteDestinationLimit value
     * @return string|null
     */
    public function getRemoteDestinationLimit()
    {
        return $this->remoteDestinationLimit;
    }
    /**
     * Set remoteDestinationLimit value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteDestinationLimit
     * @return RFeatureGroupTemplate
     */
    public function setRemoteDestinationLimit($remoteDestinationLimit = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($remoteDestinationLimit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $remoteDestinationLimit, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->remoteDestinationLimit = $remoteDestinationLimit;
        return $this;
    }
    /**
     * Get BLFPresenceGp value
     * @return XFkType|null
     */
    public function getBLFPresenceGp()
    {
        return $this->BLFPresenceGp;
    }
    /**
     * Set BLFPresenceGp value
     * @param XFkType $bLFPresenceGp
     * @return RFeatureGroupTemplate
     */
    public function setBLFPresenceGp(XFkType $bLFPresenceGp = null)
    {
        $this->BLFPresenceGp = $bLFPresenceGp;
        return $this;
    }
    /**
     * Get subscribeCallingSearch value
     * @return XFkType|null
     */
    public function getSubscribeCallingSearch()
    {
        return $this->subscribeCallingSearch;
    }
    /**
     * Set subscribeCallingSearch value
     * @param XFkType $subscribeCallingSearch
     * @return RFeatureGroupTemplate
     */
    public function setSubscribeCallingSearch(XFkType $subscribeCallingSearch = null)
    {
        $this->subscribeCallingSearch = $subscribeCallingSearch;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return RFeatureGroupTemplate
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get userProfile value
     * @return XFkType|null
     */
    public function getUserProfile()
    {
        return $this->userProfile;
    }
    /**
     * Set userProfile value
     * @param XFkType $userProfile
     * @return RFeatureGroupTemplate
     */
    public function setUserProfile(XFkType $userProfile = null)
    {
        $this->userProfile = $userProfile;
        return $this;
    }
    /**
     * Get meetingInformation value
     * @return string|null
     */
    public function getMeetingInformation()
    {
        return $this->meetingInformation;
    }
    /**
     * Set meetingInformation value
     * @param string $meetingInformation
     * @return RFeatureGroupTemplate
     */
    public function setMeetingInformation($meetingInformation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($meetingInformation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $meetingInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($meetingInformation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($meetingInformation) && !is_string($meetingInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meetingInformation)), __LINE__);
        }
        $this->meetingInformation = $meetingInformation;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RFeatureGroupTemplate
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RFeatureGroupTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
