<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RExtension StructType
 * @subpackage Structs
 */
class RExtension extends AbstractStructBase
{
    /**
     * The sortOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sortOrder;
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $pattern;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routePartition;
    /**
     * The linePrimaryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $linePrimaryUri;
    /**
     * The partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $partition;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RExtension
     * @uses RExtension::setSortOrder()
     * @uses RExtension::setPattern()
     * @uses RExtension::setRoutePartition()
     * @uses RExtension::setLinePrimaryUri()
     * @uses RExtension::setPartition()
     * @uses RExtension::setUuid()
     * @param string $sortOrder
     * @param XFkType $pattern
     * @param string $routePartition
     * @param string $linePrimaryUri
     * @param XFkType $partition
     * @param string $uuid
     */
    public function __construct($sortOrder = null, XFkType $pattern = null, $routePartition = null, $linePrimaryUri = null, XFkType $partition = null, $uuid = null)
    {
        $this
            ->setSortOrder($sortOrder)
            ->setPattern($pattern)
            ->setRoutePartition($routePartition)
            ->setLinePrimaryUri($linePrimaryUri)
            ->setPartition($partition)
            ->setUuid($uuid);
    }
    /**
     * Get sortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return RExtension
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortOrder, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get pattern value
     * @return XFkType|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param XFkType $pattern
     * @return RExtension
     */
    public function setPattern(XFkType $pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartition value
     * @return string|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param string $routePartition
     * @return RExtension
     */
    public function setRoutePartition($routePartition = null)
    {
        // validation for constraint: string
        if (!is_null($routePartition) && !is_string($routePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePartition)), __LINE__);
        }
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get linePrimaryUri value
     * @return string|null
     */
    public function getLinePrimaryUri()
    {
        return $this->linePrimaryUri;
    }
    /**
     * Set linePrimaryUri value
     * @param string $linePrimaryUri
     * @return RExtension
     */
    public function setLinePrimaryUri($linePrimaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($linePrimaryUri) && !is_string($linePrimaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linePrimaryUri)), __LINE__);
        }
        $this->linePrimaryUri = $linePrimaryUri;
        return $this;
    }
    /**
     * Get partition value
     * @return XFkType|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param XFkType $partition
     * @return RExtension
     */
    public function setPartition(XFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RExtension
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RExtension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
