<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDirectoryUri StructType
 * @subpackage Structs
 */
class RDirectoryUri extends AbstractStructBase
{
    /**
     * The isPrimary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPrimary;
    /**
     * The uri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $uri;
    /**
     * The partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $partition;
    /**
     * The advertiseGloballyViaIls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $advertiseGloballyViaIls;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDirectoryUri
     * @uses RDirectoryUri::setIsPrimary()
     * @uses RDirectoryUri::setUri()
     * @uses RDirectoryUri::setPartition()
     * @uses RDirectoryUri::setAdvertiseGloballyViaIls()
     * @uses RDirectoryUri::setUuid()
     * @param string $isPrimary
     * @param string $uri
     * @param XFkType $partition
     * @param string $advertiseGloballyViaIls
     * @param string $uuid
     */
    public function __construct($isPrimary = null, $uri = null, XFkType $partition = null, $advertiseGloballyViaIls = null, $uuid = null)
    {
        $this
            ->setIsPrimary($isPrimary)
            ->setUri($uri)
            ->setPartition($partition)
            ->setAdvertiseGloballyViaIls($advertiseGloballyViaIls)
            ->setUuid($uuid);
    }
    /**
     * Get isPrimary value
     * @return string|null
     */
    public function getIsPrimary()
    {
        return $this->isPrimary;
    }
    /**
     * Set isPrimary value
     * @param string $isPrimary
     * @return RDirectoryUri
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isPrimary) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPrimary, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPrimary) && !is_string($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPrimary)), __LINE__);
        }
        $this->isPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return RDirectoryUri
     */
    public function setUri($uri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uri) && strlen($uri) > 128) || (is_array($uri) && count($uri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($uri) ? strlen($uri) : count($uri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
    /**
     * Get partition value
     * @return XFkType|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param XFkType $partition
     * @return RDirectoryUri
     */
    public function setPartition(XFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get advertiseGloballyViaIls value
     * @return string|null
     */
    public function getAdvertiseGloballyViaIls()
    {
        return $this->advertiseGloballyViaIls;
    }
    /**
     * Set advertiseGloballyViaIls value
     * @param string $advertiseGloballyViaIls
     * @return RDirectoryUri
     */
    public function setAdvertiseGloballyViaIls($advertiseGloballyViaIls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($advertiseGloballyViaIls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $advertiseGloballyViaIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($advertiseGloballyViaIls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($advertiseGloballyViaIls) && !is_string($advertiseGloballyViaIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advertiseGloballyViaIls)), __LINE__);
        }
        $this->advertiseGloballyViaIls = $advertiseGloballyViaIls;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RDirectoryUri
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RDirectoryUri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
