<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallsQueue StructType
 * @subpackage Structs
 */
class RCallsQueue extends AbstractStructBase
{
    /**
     * The maxCallersInQueue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxCallersInQueue;
    /**
     * The queueFullDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $queueFullDestination;
    /**
     * The callingSearchSpacePilotQueueFull
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpacePilotQueueFull;
    /**
     * The maxWaitTimeInQueue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxWaitTimeInQueue;
    /**
     * The maxWaitTimeDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $maxWaitTimeDestination;
    /**
     * The callingSearchSpaceMaxWaitTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpaceMaxWaitTime;
    /**
     * The noAgentDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $noAgentDestination;
    /**
     * The callingSearchSpaceNoAgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpaceNoAgent;
    /**
     * The networkHoldMohAudioSourceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceID;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCallsQueue
     * @uses RCallsQueue::setMaxCallersInQueue()
     * @uses RCallsQueue::setQueueFullDestination()
     * @uses RCallsQueue::setCallingSearchSpacePilotQueueFull()
     * @uses RCallsQueue::setMaxWaitTimeInQueue()
     * @uses RCallsQueue::setMaxWaitTimeDestination()
     * @uses RCallsQueue::setCallingSearchSpaceMaxWaitTime()
     * @uses RCallsQueue::setNoAgentDestination()
     * @uses RCallsQueue::setCallingSearchSpaceNoAgent()
     * @uses RCallsQueue::setNetworkHoldMohAudioSourceID()
     * @uses RCallsQueue::setUuid()
     * @param string $maxCallersInQueue
     * @param string $queueFullDestination
     * @param XFkType $callingSearchSpacePilotQueueFull
     * @param string $maxWaitTimeInQueue
     * @param string $maxWaitTimeDestination
     * @param XFkType $callingSearchSpaceMaxWaitTime
     * @param string $noAgentDestination
     * @param XFkType $callingSearchSpaceNoAgent
     * @param string $networkHoldMohAudioSourceID
     * @param string $uuid
     */
    public function __construct($maxCallersInQueue = null, $queueFullDestination = null, XFkType $callingSearchSpacePilotQueueFull = null, $maxWaitTimeInQueue = null, $maxWaitTimeDestination = null, XFkType $callingSearchSpaceMaxWaitTime = null, $noAgentDestination = null, XFkType $callingSearchSpaceNoAgent = null, $networkHoldMohAudioSourceID = null, $uuid = null)
    {
        $this
            ->setMaxCallersInQueue($maxCallersInQueue)
            ->setQueueFullDestination($queueFullDestination)
            ->setCallingSearchSpacePilotQueueFull($callingSearchSpacePilotQueueFull)
            ->setMaxWaitTimeInQueue($maxWaitTimeInQueue)
            ->setMaxWaitTimeDestination($maxWaitTimeDestination)
            ->setCallingSearchSpaceMaxWaitTime($callingSearchSpaceMaxWaitTime)
            ->setNoAgentDestination($noAgentDestination)
            ->setCallingSearchSpaceNoAgent($callingSearchSpaceNoAgent)
            ->setNetworkHoldMohAudioSourceID($networkHoldMohAudioSourceID)
            ->setUuid($uuid);
    }
    /**
     * Get maxCallersInQueue value
     * @return string|null
     */
    public function getMaxCallersInQueue()
    {
        return $this->maxCallersInQueue;
    }
    /**
     * Set maxCallersInQueue value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxCallersInQueue
     * @return RCallsQueue
     */
    public function setMaxCallersInQueue($maxCallersInQueue = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxCallersInQueue)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxCallersInQueue, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxCallersInQueue = $maxCallersInQueue;
        return $this;
    }
    /**
     * Get queueFullDestination value
     * @return string|null
     */
    public function getQueueFullDestination()
    {
        return $this->queueFullDestination;
    }
    /**
     * Set queueFullDestination value
     * @param string $queueFullDestination
     * @return RCallsQueue
     */
    public function setQueueFullDestination($queueFullDestination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($queueFullDestination) && strlen($queueFullDestination) > 50) || (is_array($queueFullDestination) && count($queueFullDestination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($queueFullDestination) ? strlen($queueFullDestination) : count($queueFullDestination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($queueFullDestination) && !is_string($queueFullDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueFullDestination)), __LINE__);
        }
        $this->queueFullDestination = $queueFullDestination;
        return $this;
    }
    /**
     * Get callingSearchSpacePilotQueueFull value
     * @return XFkType|null
     */
    public function getCallingSearchSpacePilotQueueFull()
    {
        return $this->callingSearchSpacePilotQueueFull;
    }
    /**
     * Set callingSearchSpacePilotQueueFull value
     * @param XFkType $callingSearchSpacePilotQueueFull
     * @return RCallsQueue
     */
    public function setCallingSearchSpacePilotQueueFull(XFkType $callingSearchSpacePilotQueueFull = null)
    {
        $this->callingSearchSpacePilotQueueFull = $callingSearchSpacePilotQueueFull;
        return $this;
    }
    /**
     * Get maxWaitTimeInQueue value
     * @return string|null
     */
    public function getMaxWaitTimeInQueue()
    {
        return $this->maxWaitTimeInQueue;
    }
    /**
     * Set maxWaitTimeInQueue value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxWaitTimeInQueue
     * @return RCallsQueue
     */
    public function setMaxWaitTimeInQueue($maxWaitTimeInQueue = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxWaitTimeInQueue)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxWaitTimeInQueue, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxWaitTimeInQueue = $maxWaitTimeInQueue;
        return $this;
    }
    /**
     * Get maxWaitTimeDestination value
     * @return string|null
     */
    public function getMaxWaitTimeDestination()
    {
        return $this->maxWaitTimeDestination;
    }
    /**
     * Set maxWaitTimeDestination value
     * @param string $maxWaitTimeDestination
     * @return RCallsQueue
     */
    public function setMaxWaitTimeDestination($maxWaitTimeDestination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($maxWaitTimeDestination) && strlen($maxWaitTimeDestination) > 50) || (is_array($maxWaitTimeDestination) && count($maxWaitTimeDestination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($maxWaitTimeDestination) ? strlen($maxWaitTimeDestination) : count($maxWaitTimeDestination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($maxWaitTimeDestination) && !is_string($maxWaitTimeDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxWaitTimeDestination)), __LINE__);
        }
        $this->maxWaitTimeDestination = $maxWaitTimeDestination;
        return $this;
    }
    /**
     * Get callingSearchSpaceMaxWaitTime value
     * @return XFkType|null
     */
    public function getCallingSearchSpaceMaxWaitTime()
    {
        return $this->callingSearchSpaceMaxWaitTime;
    }
    /**
     * Set callingSearchSpaceMaxWaitTime value
     * @param XFkType $callingSearchSpaceMaxWaitTime
     * @return RCallsQueue
     */
    public function setCallingSearchSpaceMaxWaitTime(XFkType $callingSearchSpaceMaxWaitTime = null)
    {
        $this->callingSearchSpaceMaxWaitTime = $callingSearchSpaceMaxWaitTime;
        return $this;
    }
    /**
     * Get noAgentDestination value
     * @return string|null
     */
    public function getNoAgentDestination()
    {
        return $this->noAgentDestination;
    }
    /**
     * Set noAgentDestination value
     * @param string $noAgentDestination
     * @return RCallsQueue
     */
    public function setNoAgentDestination($noAgentDestination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($noAgentDestination) && strlen($noAgentDestination) > 50) || (is_array($noAgentDestination) && count($noAgentDestination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($noAgentDestination) ? strlen($noAgentDestination) : count($noAgentDestination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noAgentDestination) && !is_string($noAgentDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noAgentDestination)), __LINE__);
        }
        $this->noAgentDestination = $noAgentDestination;
        return $this;
    }
    /**
     * Get callingSearchSpaceNoAgent value
     * @return XFkType|null
     */
    public function getCallingSearchSpaceNoAgent()
    {
        return $this->callingSearchSpaceNoAgent;
    }
    /**
     * Set callingSearchSpaceNoAgent value
     * @param XFkType $callingSearchSpaceNoAgent
     * @return RCallsQueue
     */
    public function setCallingSearchSpaceNoAgent(XFkType $callingSearchSpaceNoAgent = null)
    {
        $this->callingSearchSpaceNoAgent = $callingSearchSpaceNoAgent;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceID value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceID()
    {
        return $this->networkHoldMohAudioSourceID;
    }
    /**
     * Set networkHoldMohAudioSourceID value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceID
     * @return RCallsQueue
     */
    public function setNetworkHoldMohAudioSourceID($networkHoldMohAudioSourceID = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($networkHoldMohAudioSourceID)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceID, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSourceID = $networkHoldMohAudioSourceID;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RCallsQueue
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RCallsQueue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
