<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAssignedPresenceUsers StructType
 * @subpackage Structs
 */
class RAssignedPresenceUsers extends AbstractStructBase
{
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The server
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $server;
    /**
     * The presenceRedundancyGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $presenceRedundancyGroup;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAssignedPresenceUsers
     * @uses RAssignedPresenceUsers::setUserid()
     * @uses RAssignedPresenceUsers::setServer()
     * @uses RAssignedPresenceUsers::setPresenceRedundancyGroup()
     * @uses RAssignedPresenceUsers::setUuid()
     * @param string $userid
     * @param XFkType $server
     * @param string $presenceRedundancyGroup
     * @param string $uuid
     */
    public function __construct($userid = null, XFkType $server = null, $presenceRedundancyGroup = null, $uuid = null)
    {
        $this
            ->setUserid($userid)
            ->setServer($server)
            ->setPresenceRedundancyGroup($presenceRedundancyGroup)
            ->setUuid($uuid);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return RAssignedPresenceUsers
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get server value
     * @return XFkType|null
     */
    public function getServer()
    {
        return $this->server;
    }
    /**
     * Set server value
     * @param XFkType $server
     * @return RAssignedPresenceUsers
     */
    public function setServer(XFkType $server = null)
    {
        $this->server = $server;
        return $this;
    }
    /**
     * Get presenceRedundancyGroup value
     * @return string|null
     */
    public function getPresenceRedundancyGroup()
    {
        return $this->presenceRedundancyGroup;
    }
    /**
     * Set presenceRedundancyGroup value
     * @param string $presenceRedundancyGroup
     * @return RAssignedPresenceUsers
     */
    public function setPresenceRedundancyGroup($presenceRedundancyGroup = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($presenceRedundancyGroup) && strlen($presenceRedundancyGroup) > 255) || (is_array($presenceRedundancyGroup) && count($presenceRedundancyGroup) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($presenceRedundancyGroup) ? strlen($presenceRedundancyGroup) : count($presenceRedundancyGroup)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($presenceRedundancyGroup) && !is_string($presenceRedundancyGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($presenceRedundancyGroup)), __LINE__);
        }
        $this->presenceRedundancyGroup = $presenceRedundancyGroup;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RAssignedPresenceUsers
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RAssignedPresenceUsers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
