<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ports StructType
 * @subpackage Structs
 */
class Ports extends AbstractStructBase
{
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var XAnalogPort[]
     */
    public $port;
    /**
     * The ethernetPhonePort
     * Meta informations extracted from the WSDL
     * - default: 2000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ethernetPhonePort;
    /**
     * The mgcpPorts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var MgcpPorts
     */
    public $mgcpPorts;
    /**
     * The sipPorts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var SipPorts
     */
    public $sipPorts;
    /**
     * Constructor method for ports
     * @uses Ports::setPort()
     * @uses Ports::setEthernetPhonePort()
     * @uses Ports::setMgcpPorts()
     * @uses Ports::setSipPorts()
     * @param XAnalogPort[] $port
     * @param string $ethernetPhonePort
     * @param MgcpPorts $mgcpPorts
     * @param SipPorts $sipPorts
     */
    public function __construct(array $port = array(), $ethernetPhonePort = '2000', MgcpPorts $mgcpPorts = null, SipPorts $sipPorts = null)
    {
        $this
            ->setPort($port)
            ->setEthernetPhonePort($ethernetPhonePort)
            ->setMgcpPorts($mgcpPorts)
            ->setSipPorts($sipPorts);
    }
    /**
     * Get port value
     * @return XAnalogPort[]
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @throws \InvalidArgumentException
     * @param XAnalogPort[] $port
     * @return Ports
     */
    public function setPort(array $port = array())
    {
        foreach ($port as $portsPortItem) {
            // validation for constraint: itemType
            if (!$portsPortItem instanceof XAnalogPort) {
                throw new \InvalidArgumentException(sprintf('The port property can only contain items of XAnalogPort, "%s" given', is_object($portsPortItem) ? get_class($portsPortItem) : gettype($portsPortItem)), __LINE__);
            }
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Add item to port value
     * @throws \InvalidArgumentException
     * @param XAnalogPort $item
     * @return Ports
     */
    public function addToPort(XAnalogPort $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof XAnalogPort) {
            throw new \InvalidArgumentException(sprintf('The port property can only contain items of XAnalogPort, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->port[] = $item;
        return $this;
    }
    /**
     * Get ethernetPhonePort value
     * @return string|null
     */
    public function getEthernetPhonePort()
    {
        return $this->ethernetPhonePort;
    }
    /**
     * Set ethernetPhonePort value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ethernetPhonePort
     * @return Ports
     */
    public function setEthernetPhonePort($ethernetPhonePort = '2000')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($ethernetPhonePort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ethernetPhonePort, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->ethernetPhonePort = $ethernetPhonePort;
        return $this;
    }
    /**
     * Get mgcpPorts value
     * @return MgcpPorts|null
     */
    public function getMgcpPorts()
    {
        return $this->mgcpPorts;
    }
    /**
     * Set mgcpPorts value
     * @param MgcpPorts $mgcpPorts
     * @return Ports
     */
    public function setMgcpPorts(MgcpPorts $mgcpPorts = null)
    {
        $this->mgcpPorts = $mgcpPorts;
        return $this;
    }
    /**
     * Get sipPorts value
     * @return SipPorts|null
     */
    public function getSipPorts()
    {
        return $this->sipPorts;
    }
    /**
     * Set sipPorts value
     * @param SipPorts $sipPorts
     * @return Ports
     */
    public function setSipPorts(SipPorts $sipPorts = null)
    {
        $this->sipPorts = $sipPorts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Ports
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
