<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXTransPattern StructType
 * @subpackage Structs
 */
class OXTransPattern extends AbstractStructBase
{
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $routePartitionName;
    /**
     * The useCallingPartyPhoneMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $useCallingPartyPhoneMask;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $patternPrecedence;
    /**
     * The callingPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $calledPartyNumberType;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callingSearchSpaceName;
    /**
     * The resourcePriorityNamespaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $routeClass;
    /**
     * The callInterceptProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callInterceptProfileName;
    /**
     * The releaseClause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $releaseClause;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXTransPattern
     * @uses OXTransPattern::setUsage()
     * @uses OXTransPattern::setRoutePartitionName()
     * @uses OXTransPattern::setUseCallingPartyPhoneMask()
     * @uses OXTransPattern::setDialPlanName()
     * @uses OXTransPattern::setDigitDiscardInstructionName()
     * @uses OXTransPattern::setRouteFilterName()
     * @uses OXTransPattern::setCallingLinePresentationBit()
     * @uses OXTransPattern::setCallingNamePresentationBit()
     * @uses OXTransPattern::setConnectedLinePresentationBit()
     * @uses OXTransPattern::setConnectedNamePresentationBit()
     * @uses OXTransPattern::setPatternPrecedence()
     * @uses OXTransPattern::setCallingPartyNumberingPlan()
     * @uses OXTransPattern::setCallingPartyNumberType()
     * @uses OXTransPattern::setCalledPartyNumberingPlan()
     * @uses OXTransPattern::setCalledPartyNumberType()
     * @uses OXTransPattern::setCallingSearchSpaceName()
     * @uses OXTransPattern::setResourcePriorityNamespaceName()
     * @uses OXTransPattern::setRouteClass()
     * @uses OXTransPattern::setCallInterceptProfileName()
     * @uses OXTransPattern::setReleaseClause()
     * @uses OXTransPattern::setUuid()
     * @param OXFkType $usage
     * @param OXFkType $routePartitionName
     * @param OXFkType $useCallingPartyPhoneMask
     * @param OXFkType $dialPlanName
     * @param OXFkType $digitDiscardInstructionName
     * @param OXFkType $routeFilterName
     * @param OXFkType $callingLinePresentationBit
     * @param OXFkType $callingNamePresentationBit
     * @param OXFkType $connectedLinePresentationBit
     * @param OXFkType $connectedNamePresentationBit
     * @param OXFkType $patternPrecedence
     * @param OXFkType $callingPartyNumberingPlan
     * @param OXFkType $callingPartyNumberType
     * @param OXFkType $calledPartyNumberingPlan
     * @param OXFkType $calledPartyNumberType
     * @param OXFkType $callingSearchSpaceName
     * @param OXFkType $resourcePriorityNamespaceName
     * @param OXFkType $routeClass
     * @param OXFkType $callInterceptProfileName
     * @param OXFkType $releaseClause
     * @param string $uuid
     */
    public function __construct(OXFkType $usage = null, OXFkType $routePartitionName = null, OXFkType $useCallingPartyPhoneMask = null, OXFkType $dialPlanName = null, OXFkType $digitDiscardInstructionName = null, OXFkType $routeFilterName = null, OXFkType $callingLinePresentationBit = null, OXFkType $callingNamePresentationBit = null, OXFkType $connectedLinePresentationBit = null, OXFkType $connectedNamePresentationBit = null, OXFkType $patternPrecedence = null, OXFkType $callingPartyNumberingPlan = null, OXFkType $callingPartyNumberType = null, OXFkType $calledPartyNumberingPlan = null, OXFkType $calledPartyNumberType = null, OXFkType $callingSearchSpaceName = null, OXFkType $resourcePriorityNamespaceName = null, OXFkType $routeClass = null, OXFkType $callInterceptProfileName = null, OXFkType $releaseClause = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteClass($routeClass)
            ->setCallInterceptProfileName($callInterceptProfileName)
            ->setReleaseClause($releaseClause)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return OXFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param OXFkType $usage
     * @return OXTransPattern
     */
    public function setUsage(OXFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return OXFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param OXFkType $routePartitionName
     * @return OXTransPattern
     */
    public function setRoutePartitionName(OXFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return OXFkType|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param OXFkType $useCallingPartyPhoneMask
     * @return OXTransPattern
     */
    public function setUseCallingPartyPhoneMask(OXFkType $useCallingPartyPhoneMask = null)
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return OXFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param OXFkType $dialPlanName
     * @return OXTransPattern
     */
    public function setDialPlanName(OXFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return OXFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param OXFkType $digitDiscardInstructionName
     * @return OXTransPattern
     */
    public function setDigitDiscardInstructionName(OXFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return OXFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param OXFkType $routeFilterName
     * @return OXTransPattern
     */
    public function setRouteFilterName(OXFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return OXFkType|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param OXFkType $callingLinePresentationBit
     * @return OXTransPattern
     */
    public function setCallingLinePresentationBit(OXFkType $callingLinePresentationBit = null)
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return OXFkType|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param OXFkType $callingNamePresentationBit
     * @return OXTransPattern
     */
    public function setCallingNamePresentationBit(OXFkType $callingNamePresentationBit = null)
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return OXFkType|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param OXFkType $connectedLinePresentationBit
     * @return OXTransPattern
     */
    public function setConnectedLinePresentationBit(OXFkType $connectedLinePresentationBit = null)
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return OXFkType|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param OXFkType $connectedNamePresentationBit
     * @return OXTransPattern
     */
    public function setConnectedNamePresentationBit(OXFkType $connectedNamePresentationBit = null)
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return OXFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param OXFkType $patternPrecedence
     * @return OXTransPattern
     */
    public function setPatternPrecedence(OXFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return OXFkType|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @param OXFkType $callingPartyNumberingPlan
     * @return OXTransPattern
     */
    public function setCallingPartyNumberingPlan(OXFkType $callingPartyNumberingPlan = null)
    {
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return OXFkType|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @param OXFkType $callingPartyNumberType
     * @return OXTransPattern
     */
    public function setCallingPartyNumberType(OXFkType $callingPartyNumberType = null)
    {
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return OXFkType|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @param OXFkType $calledPartyNumberingPlan
     * @return OXTransPattern
     */
    public function setCalledPartyNumberingPlan(OXFkType $calledPartyNumberingPlan = null)
    {
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return OXFkType|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @param OXFkType $calledPartyNumberType
     * @return OXTransPattern
     */
    public function setCalledPartyNumberType(OXFkType $calledPartyNumberType = null)
    {
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return OXFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param OXFkType $callingSearchSpaceName
     * @return OXTransPattern
     */
    public function setCallingSearchSpaceName(OXFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return OXFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param OXFkType $resourcePriorityNamespaceName
     * @return OXTransPattern
     */
    public function setResourcePriorityNamespaceName(OXFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get routeClass value
     * @return OXFkType|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @param OXFkType $routeClass
     * @return OXTransPattern
     */
    public function setRouteClass(OXFkType $routeClass = null)
    {
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get callInterceptProfileName value
     * @return OXFkType|null
     */
    public function getCallInterceptProfileName()
    {
        return $this->callInterceptProfileName;
    }
    /**
     * Set callInterceptProfileName value
     * @param OXFkType $callInterceptProfileName
     * @return OXTransPattern
     */
    public function setCallInterceptProfileName(OXFkType $callInterceptProfileName = null)
    {
        $this->callInterceptProfileName = $callInterceptProfileName;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return OXFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param OXFkType $releaseClause
     * @return OXTransPattern
     */
    public function setReleaseClause(OXFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return OXTransPattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return OXTransPattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
