<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXPhoneLine StructType
 * @subpackage Structs
 */
class OXPhoneLine extends AbstractStructBase
{
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXDirn
     */
    public $dirn;
    /**
     * The ringSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $ringSetting;
    /**
     * The consecutiveRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: Consecutive Rings Setting. Replaces the consective ring setting on IPPhone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $consecutiveRingSetting;
    /**
     * The ringSettingIdlePickupAlert
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $ringSettingIdlePickupAlert;
    /**
     * The ringSettingActivePickupAlert
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $ringSettingActivePickupAlert;
    /**
     * The mwlPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $mwlPolicy;
    /**
     * The recordingProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta informations extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $audibleMwi;
    /**
     * The partitionUsage
     * Meta informations extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $partitionUsage;
    /**
     * The recordingMediaSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $recordingMediaSource;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXPhoneLine
     * @uses OXPhoneLine::setDirn()
     * @uses OXPhoneLine::setRingSetting()
     * @uses OXPhoneLine::setConsecutiveRingSetting()
     * @uses OXPhoneLine::setRingSettingIdlePickupAlert()
     * @uses OXPhoneLine::setRingSettingActivePickupAlert()
     * @uses OXPhoneLine::setMwlPolicy()
     * @uses OXPhoneLine::setRecordingProfileName()
     * @uses OXPhoneLine::setMonitoringCssName()
     * @uses OXPhoneLine::setRecordingFlag()
     * @uses OXPhoneLine::setAudibleMwi()
     * @uses OXPhoneLine::setPartitionUsage()
     * @uses OXPhoneLine::setRecordingMediaSource()
     * @uses OXPhoneLine::setCtiid()
     * @uses OXPhoneLine::setUuid()
     * @param OXDirn $dirn
     * @param OXFkType $ringSetting
     * @param OXFkType $consecutiveRingSetting
     * @param OXFkType $ringSettingIdlePickupAlert
     * @param OXFkType $ringSettingActivePickupAlert
     * @param OXFkType $mwlPolicy
     * @param OXFkType $recordingProfileName
     * @param OXFkType $monitoringCssName
     * @param OXFkType $recordingFlag
     * @param OXFkType $audibleMwi
     * @param OXFkType $partitionUsage
     * @param OXFkType $recordingMediaSource
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(OXDirn $dirn = null, OXFkType $ringSetting = null, OXFkType $consecutiveRingSetting = null, OXFkType $ringSettingIdlePickupAlert = null, OXFkType $ringSettingActivePickupAlert = null, OXFkType $mwlPolicy = null, OXFkType $recordingProfileName = null, OXFkType $monitoringCssName = null, OXFkType $recordingFlag = null, OXFkType $audibleMwi = null, OXFkType $partitionUsage = null, OXFkType $recordingMediaSource = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setDirn($dirn)
            ->setRingSetting($ringSetting)
            ->setConsecutiveRingSetting($consecutiveRingSetting)
            ->setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert)
            ->setRingSettingActivePickupAlert($ringSettingActivePickupAlert)
            ->setMwlPolicy($mwlPolicy)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setPartitionUsage($partitionUsage)
            ->setRecordingMediaSource($recordingMediaSource)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get dirn value
     * @return OXDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param OXDirn $dirn
     * @return OXPhoneLine
     */
    public function setDirn(OXDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get ringSetting value
     * @return OXFkType|null
     */
    public function getRingSetting()
    {
        return $this->ringSetting;
    }
    /**
     * Set ringSetting value
     * @param OXFkType $ringSetting
     * @return OXPhoneLine
     */
    public function setRingSetting(OXFkType $ringSetting = null)
    {
        $this->ringSetting = $ringSetting;
        return $this;
    }
    /**
     * Get consecutiveRingSetting value
     * @return OXFkType|null
     */
    public function getConsecutiveRingSetting()
    {
        return $this->consecutiveRingSetting;
    }
    /**
     * Set consecutiveRingSetting value
     * @param OXFkType $consecutiveRingSetting
     * @return OXPhoneLine
     */
    public function setConsecutiveRingSetting(OXFkType $consecutiveRingSetting = null)
    {
        $this->consecutiveRingSetting = $consecutiveRingSetting;
        return $this;
    }
    /**
     * Get ringSettingIdlePickupAlert value
     * @return OXFkType|null
     */
    public function getRingSettingIdlePickupAlert()
    {
        return $this->ringSettingIdlePickupAlert;
    }
    /**
     * Set ringSettingIdlePickupAlert value
     * @param OXFkType $ringSettingIdlePickupAlert
     * @return OXPhoneLine
     */
    public function setRingSettingIdlePickupAlert(OXFkType $ringSettingIdlePickupAlert = null)
    {
        $this->ringSettingIdlePickupAlert = $ringSettingIdlePickupAlert;
        return $this;
    }
    /**
     * Get ringSettingActivePickupAlert value
     * @return OXFkType|null
     */
    public function getRingSettingActivePickupAlert()
    {
        return $this->ringSettingActivePickupAlert;
    }
    /**
     * Set ringSettingActivePickupAlert value
     * @param OXFkType $ringSettingActivePickupAlert
     * @return OXPhoneLine
     */
    public function setRingSettingActivePickupAlert(OXFkType $ringSettingActivePickupAlert = null)
    {
        $this->ringSettingActivePickupAlert = $ringSettingActivePickupAlert;
        return $this;
    }
    /**
     * Get mwlPolicy value
     * @return OXFkType|null
     */
    public function getMwlPolicy()
    {
        return $this->mwlPolicy;
    }
    /**
     * Set mwlPolicy value
     * @param OXFkType $mwlPolicy
     * @return OXPhoneLine
     */
    public function setMwlPolicy(OXFkType $mwlPolicy = null)
    {
        $this->mwlPolicy = $mwlPolicy;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * @return OXFkType|null
     */
    public function getRecordingProfileName()
    {
        return $this->recordingProfileName;
    }
    /**
     * Set recordingProfileName value
     * @param OXFkType $recordingProfileName
     * @return OXPhoneLine
     */
    public function setRecordingProfileName(OXFkType $recordingProfileName = null)
    {
        $this->recordingProfileName = $recordingProfileName;
        return $this;
    }
    /**
     * Get monitoringCssName value
     * @return OXFkType|null
     */
    public function getMonitoringCssName()
    {
        return $this->monitoringCssName;
    }
    /**
     * Set monitoringCssName value
     * @param OXFkType $monitoringCssName
     * @return OXPhoneLine
     */
    public function setMonitoringCssName(OXFkType $monitoringCssName = null)
    {
        $this->monitoringCssName = $monitoringCssName;
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return OXFkType|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @param OXFkType $recordingFlag
     * @return OXPhoneLine
     */
    public function setRecordingFlag(OXFkType $recordingFlag = null)
    {
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return OXFkType|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @param OXFkType $audibleMwi
     * @return OXPhoneLine
     */
    public function setAudibleMwi(OXFkType $audibleMwi = null)
    {
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return OXFkType|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @param OXFkType $partitionUsage
     * @return OXPhoneLine
     */
    public function setPartitionUsage(OXFkType $partitionUsage = null)
    {
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get recordingMediaSource value
     * @return OXFkType|null
     */
    public function getRecordingMediaSource()
    {
        return $this->recordingMediaSource;
    }
    /**
     * Set recordingMediaSource value
     * @param OXFkType $recordingMediaSource
     * @return OXPhoneLine
     */
    public function setRecordingMediaSource(OXFkType $recordingMediaSource = null)
    {
        $this->recordingMediaSource = $recordingMediaSource;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return OXPhoneLine
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return OXPhoneLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return OXPhoneLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
