<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXFkTypeProduct_Protocol StructType
 * @subpackage Structs
 */
class OXFkTypeProduct_Protocol extends OXFkType
{
    /**
     * The product
     * @var string
     */
    public $product;
    /**
     * The protocol
     * @var string
     */
    public $protocol;
    /**
     * Constructor method for OXFkTypeProduct_Protocol
     * @uses OXFkTypeProduct_Protocol::setProduct()
     * @uses OXFkTypeProduct_Protocol::setProtocol()
     * @param string $product
     * @param string $protocol
     */
    public function __construct($product = null, $protocol = null)
    {
        $this
            ->setProduct($product)
            ->setProtocol($protocol);
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return OXFkTypeProduct_Protocol
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return OXFkTypeProduct_Protocol
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($protocol)), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return OXFkTypeProduct_Protocol
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
