<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXAddOnModule StructType
 * @subpackage Structs
 */
class OXAddOnModule extends AbstractStructBase
{
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - documentation: Model ID string.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkTypeProduct_Protocol
     */
    public $model;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXAddOnModule
     * @uses OXAddOnModule::setModel()
     * @uses OXAddOnModule::setUuid()
     * @param OXFkTypeProduct_Protocol $model
     * @param string $uuid
     */
    public function __construct(OXFkTypeProduct_Protocol $model = null, $uuid = null)
    {
        $this
            ->setModel($model)
            ->setUuid($uuid);
    }
    /**
     * Get model value
     * @return OXFkTypeProduct_Protocol|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param OXFkTypeProduct_Protocol $model
     * @return OXAddOnModule
     */
    public function setModel(OXFkTypeProduct_Protocol $model = null)
    {
        $this->model = $model;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return OXAddOnModule
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return OXAddOnModule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
