<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORTransPattern StructType
 * @subpackage Structs
 */
class ORTransPattern extends AbstractStructBase
{
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $routePartitionName;
    /**
     * The useCallingPartyPhoneMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $useCallingPartyPhoneMask;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $patternPrecedence;
    /**
     * The callingPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $calledPartyNumberType;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callingSearchSpaceName;
    /**
     * The resourcePriorityNamespaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $routeClass;
    /**
     * The callInterceptProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callInterceptProfileName;
    /**
     * The releaseClause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $releaseClause;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORTransPattern
     * @uses ORTransPattern::setUsage()
     * @uses ORTransPattern::setRoutePartitionName()
     * @uses ORTransPattern::setUseCallingPartyPhoneMask()
     * @uses ORTransPattern::setDialPlanName()
     * @uses ORTransPattern::setDigitDiscardInstructionName()
     * @uses ORTransPattern::setRouteFilterName()
     * @uses ORTransPattern::setCallingLinePresentationBit()
     * @uses ORTransPattern::setCallingNamePresentationBit()
     * @uses ORTransPattern::setConnectedLinePresentationBit()
     * @uses ORTransPattern::setConnectedNamePresentationBit()
     * @uses ORTransPattern::setPatternPrecedence()
     * @uses ORTransPattern::setCallingPartyNumberingPlan()
     * @uses ORTransPattern::setCallingPartyNumberType()
     * @uses ORTransPattern::setCalledPartyNumberingPlan()
     * @uses ORTransPattern::setCalledPartyNumberType()
     * @uses ORTransPattern::setCallingSearchSpaceName()
     * @uses ORTransPattern::setResourcePriorityNamespaceName()
     * @uses ORTransPattern::setRouteClass()
     * @uses ORTransPattern::setCallInterceptProfileName()
     * @uses ORTransPattern::setReleaseClause()
     * @uses ORTransPattern::setUuid()
     * @param ORFkType $usage
     * @param ORFkType $routePartitionName
     * @param ORFkType $useCallingPartyPhoneMask
     * @param ORFkType $dialPlanName
     * @param ORFkType $digitDiscardInstructionName
     * @param ORFkType $routeFilterName
     * @param ORFkType $callingLinePresentationBit
     * @param ORFkType $callingNamePresentationBit
     * @param ORFkType $connectedLinePresentationBit
     * @param ORFkType $connectedNamePresentationBit
     * @param ORFkType $patternPrecedence
     * @param ORFkType $callingPartyNumberingPlan
     * @param ORFkType $callingPartyNumberType
     * @param ORFkType $calledPartyNumberingPlan
     * @param ORFkType $calledPartyNumberType
     * @param ORFkType $callingSearchSpaceName
     * @param ORFkType $resourcePriorityNamespaceName
     * @param ORFkType $routeClass
     * @param ORFkType $callInterceptProfileName
     * @param ORFkType $releaseClause
     * @param string $uuid
     */
    public function __construct(ORFkType $usage = null, ORFkType $routePartitionName = null, ORFkType $useCallingPartyPhoneMask = null, ORFkType $dialPlanName = null, ORFkType $digitDiscardInstructionName = null, ORFkType $routeFilterName = null, ORFkType $callingLinePresentationBit = null, ORFkType $callingNamePresentationBit = null, ORFkType $connectedLinePresentationBit = null, ORFkType $connectedNamePresentationBit = null, ORFkType $patternPrecedence = null, ORFkType $callingPartyNumberingPlan = null, ORFkType $callingPartyNumberType = null, ORFkType $calledPartyNumberingPlan = null, ORFkType $calledPartyNumberType = null, ORFkType $callingSearchSpaceName = null, ORFkType $resourcePriorityNamespaceName = null, ORFkType $routeClass = null, ORFkType $callInterceptProfileName = null, ORFkType $releaseClause = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteClass($routeClass)
            ->setCallInterceptProfileName($callInterceptProfileName)
            ->setReleaseClause($releaseClause)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return ORFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param ORFkType $usage
     * @return ORTransPattern
     */
    public function setUsage(ORFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return ORFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param ORFkType $routePartitionName
     * @return ORTransPattern
     */
    public function setRoutePartitionName(ORFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return ORFkType|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param ORFkType $useCallingPartyPhoneMask
     * @return ORTransPattern
     */
    public function setUseCallingPartyPhoneMask(ORFkType $useCallingPartyPhoneMask = null)
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return ORFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param ORFkType $dialPlanName
     * @return ORTransPattern
     */
    public function setDialPlanName(ORFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return ORFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param ORFkType $digitDiscardInstructionName
     * @return ORTransPattern
     */
    public function setDigitDiscardInstructionName(ORFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return ORFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param ORFkType $routeFilterName
     * @return ORTransPattern
     */
    public function setRouteFilterName(ORFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return ORFkType|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param ORFkType $callingLinePresentationBit
     * @return ORTransPattern
     */
    public function setCallingLinePresentationBit(ORFkType $callingLinePresentationBit = null)
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return ORFkType|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param ORFkType $callingNamePresentationBit
     * @return ORTransPattern
     */
    public function setCallingNamePresentationBit(ORFkType $callingNamePresentationBit = null)
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return ORFkType|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param ORFkType $connectedLinePresentationBit
     * @return ORTransPattern
     */
    public function setConnectedLinePresentationBit(ORFkType $connectedLinePresentationBit = null)
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return ORFkType|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param ORFkType $connectedNamePresentationBit
     * @return ORTransPattern
     */
    public function setConnectedNamePresentationBit(ORFkType $connectedNamePresentationBit = null)
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return ORFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param ORFkType $patternPrecedence
     * @return ORTransPattern
     */
    public function setPatternPrecedence(ORFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return ORFkType|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @param ORFkType $callingPartyNumberingPlan
     * @return ORTransPattern
     */
    public function setCallingPartyNumberingPlan(ORFkType $callingPartyNumberingPlan = null)
    {
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return ORFkType|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @param ORFkType $callingPartyNumberType
     * @return ORTransPattern
     */
    public function setCallingPartyNumberType(ORFkType $callingPartyNumberType = null)
    {
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return ORFkType|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @param ORFkType $calledPartyNumberingPlan
     * @return ORTransPattern
     */
    public function setCalledPartyNumberingPlan(ORFkType $calledPartyNumberingPlan = null)
    {
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return ORFkType|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @param ORFkType $calledPartyNumberType
     * @return ORTransPattern
     */
    public function setCalledPartyNumberType(ORFkType $calledPartyNumberType = null)
    {
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return ORFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param ORFkType $callingSearchSpaceName
     * @return ORTransPattern
     */
    public function setCallingSearchSpaceName(ORFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return ORFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param ORFkType $resourcePriorityNamespaceName
     * @return ORTransPattern
     */
    public function setResourcePriorityNamespaceName(ORFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get routeClass value
     * @return ORFkType|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @param ORFkType $routeClass
     * @return ORTransPattern
     */
    public function setRouteClass(ORFkType $routeClass = null)
    {
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get callInterceptProfileName value
     * @return ORFkType|null
     */
    public function getCallInterceptProfileName()
    {
        return $this->callInterceptProfileName;
    }
    /**
     * Set callInterceptProfileName value
     * @param ORFkType $callInterceptProfileName
     * @return ORTransPattern
     */
    public function setCallInterceptProfileName(ORFkType $callInterceptProfileName = null)
    {
        $this->callInterceptProfileName = $callInterceptProfileName;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return ORFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param ORFkType $releaseClause
     * @return ORTransPattern
     */
    public function setReleaseClause(ORFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return ORTransPattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ORTransPattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
