<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORPhone StructType
 * @subpackage Structs
 */
class ORPhone extends AbstractStructBase
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $commonDeviceConfigName;
    /**
     * The commonPhoneConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $commonPhoneConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $aarNeighborhoodName;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta informations extracted from the WSDL
     * - documentation: This Tag is valid only for SIP Phones and SIP Trunks
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $geoLocationFilterName;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Lines
     */
    public $lines;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $phoneTemplateName;
    /**
     * The primaryPhoneName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $primaryPhoneName;
    /**
     * The ringSettingIdleBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $ringSettingIdleBlfAudibleAlert;
    /**
     * The ringSettingBusyBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $ringSettingBusyBlfAudibleAlert;
    /**
     * The blfDirectedCallParks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $networkLocale;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Services
     */
    public $services;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $softkeyTemplateName;
    /**
     * The defaultProfileName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $defaultProfileName;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $joinAcrossLines;
    /**
     * The builtInBridgeStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $builtInBridgeStatus;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callInfoPrivacyStatus;
    /**
     * The ownerUserName
     * Meta informations extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $ownerUserName;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $packetCaptureMode;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - documentation: Support for this tag has been removed for IMS phones from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $presenceGroupName;
    /**
     * The certificateOperation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - documentation: authenticationMode can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - documentation: keySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $keySize;
    /**
     * The deviceMobilityMode
     * Meta informations extracted from the WSDL
     * - documentation: Specifies if the phone is configured for device mobility or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $deviceMobilityMode;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $dndRingSetting;
    /**
     * The mobilityUserIdName
     * Meta informations extracted from the WSDL
     * - documentation: The userid of the mobility user for this phone.Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $mobilityUserIdName;
    /**
     * The phoneSuite
     * Meta informations extracted from the WSDL
     * - documentation: If a blank tag is passed ,the value of the default is inserted into the database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $phoneSuite;
    /**
     * The phoneServiceDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $phoneServiceDisplay;
    /**
     * The mtpPreferedCodec
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $mtpPreferedCodec;
    /**
     * The dialRulesName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $dialRulesName;
    /**
     * The outboundCallRollover
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that Automatic Outbound Callrollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $outboundCallRollover;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $featureControlPolicy;
    /**
     * The deviceTrustMode
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for TIP endpoints
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $deviceTrustMode;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The cgpnIngressDN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $cgpnIngressDN;
    /**
     * The wifiHotspotProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $wifiHotspotProfile;
    /**
     * The wirelessLanProfileGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORPhone
     * @uses ORPhone::setProduct()
     * @uses ORPhone::setClass()
     * @uses ORPhone::setProtocol()
     * @uses ORPhone::setProtocolSide()
     * @uses ORPhone::setCallingSearchSpaceName()
     * @uses ORPhone::setDevicePoolName()
     * @uses ORPhone::setCommonDeviceConfigName()
     * @uses ORPhone::setCommonPhoneConfigName()
     * @uses ORPhone::setNetworkLocation()
     * @uses ORPhone::setLocationName()
     * @uses ORPhone::setMediaResourceListName()
     * @uses ORPhone::setNetworkHoldMohAudioSourceId()
     * @uses ORPhone::setUserHoldMohAudioSourceId()
     * @uses ORPhone::setAutomatedAlternateRoutingCssName()
     * @uses ORPhone::setAarNeighborhoodName()
     * @uses ORPhone::setMlppIndicationStatus()
     * @uses ORPhone::setPreemption()
     * @uses ORPhone::setUseTrustedRelayPoint()
     * @uses ORPhone::setSecurityProfileName()
     * @uses ORPhone::setSipProfileName()
     * @uses ORPhone::setCgpnTransformationCssName()
     * @uses ORPhone::setGeoLocationName()
     * @uses ORPhone::setGeoLocationFilterName()
     * @uses ORPhone::setLines()
     * @uses ORPhone::setPhoneTemplateName()
     * @uses ORPhone::setPrimaryPhoneName()
     * @uses ORPhone::setRingSettingIdleBlfAudibleAlert()
     * @uses ORPhone::setRingSettingBusyBlfAudibleAlert()
     * @uses ORPhone::setBlfDirectedCallParks()
     * @uses ORPhone::setAddOnModules()
     * @uses ORPhone::setUserLocale()
     * @uses ORPhone::setNetworkLocale()
     * @uses ORPhone::setServices()
     * @uses ORPhone::setSoftkeyTemplateName()
     * @uses ORPhone::setDefaultProfileName()
     * @uses ORPhone::setSingleButtonBarge()
     * @uses ORPhone::setJoinAcrossLines()
     * @uses ORPhone::setBuiltInBridgeStatus()
     * @uses ORPhone::setCallInfoPrivacyStatus()
     * @uses ORPhone::setOwnerUserName()
     * @uses ORPhone::setPacketCaptureMode()
     * @uses ORPhone::setSubscribeCallingSearchSpaceName()
     * @uses ORPhone::setRerouteCallingSearchSpaceName()
     * @uses ORPhone::setPresenceGroupName()
     * @uses ORPhone::setCertificateOperation()
     * @uses ORPhone::setAuthenticationMode()
     * @uses ORPhone::setKeySize()
     * @uses ORPhone::setDeviceMobilityMode()
     * @uses ORPhone::setDndOption()
     * @uses ORPhone::setDndRingSetting()
     * @uses ORPhone::setMobilityUserIdName()
     * @uses ORPhone::setPhoneSuite()
     * @uses ORPhone::setPhoneServiceDisplay()
     * @uses ORPhone::setMtpPreferedCodec()
     * @uses ORPhone::setDialRulesName()
     * @uses ORPhone::setOutboundCallRollover()
     * @uses ORPhone::setAlwaysUsePrimeLine()
     * @uses ORPhone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses ORPhone::setFeatureControlPolicy()
     * @uses ORPhone::setDeviceTrustMode()
     * @uses ORPhone::setConfidentialAccess()
     * @uses ORPhone::setCgpnIngressDN()
     * @uses ORPhone::setWifiHotspotProfile()
     * @uses ORPhone::setWirelessLanProfileGroup()
     * @uses ORPhone::setCtiid()
     * @uses ORPhone::setUuid()
     * @param ORFkType $product
     * @param ORFkType $class
     * @param ORFkType $protocol
     * @param ORFkType $protocolSide
     * @param ORFkType $callingSearchSpaceName
     * @param ORFkType $devicePoolName
     * @param ORFkType $commonDeviceConfigName
     * @param ORFkType $commonPhoneConfigName
     * @param ORFkType $networkLocation
     * @param ORFkType $locationName
     * @param ORFkType $mediaResourceListName
     * @param ORFkType $networkHoldMohAudioSourceId
     * @param ORFkType $userHoldMohAudioSourceId
     * @param ORFkType $automatedAlternateRoutingCssName
     * @param ORFkType $aarNeighborhoodName
     * @param ORFkType $mlppIndicationStatus
     * @param ORFkType $preemption
     * @param ORFkType $useTrustedRelayPoint
     * @param ORFkType $securityProfileName
     * @param ORFkType $sipProfileName
     * @param ORFkType $cgpnTransformationCssName
     * @param ORFkType $geoLocationName
     * @param ORFkType $geoLocationFilterName
     * @param Lines $lines
     * @param ORFkType $phoneTemplateName
     * @param ORFkType $primaryPhoneName
     * @param ORFkType $ringSettingIdleBlfAudibleAlert
     * @param ORFkType $ringSettingBusyBlfAudibleAlert
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @param AddOnModules $addOnModules
     * @param ORFkType $userLocale
     * @param ORFkType $networkLocale
     * @param Services $services
     * @param ORFkType $softkeyTemplateName
     * @param ORFkType $defaultProfileName
     * @param ORFkType $singleButtonBarge
     * @param ORFkType $joinAcrossLines
     * @param ORFkType $builtInBridgeStatus
     * @param ORFkType $callInfoPrivacyStatus
     * @param ORFkType $ownerUserName
     * @param ORFkType $packetCaptureMode
     * @param ORFkType $subscribeCallingSearchSpaceName
     * @param ORFkType $rerouteCallingSearchSpaceName
     * @param ORFkType $presenceGroupName
     * @param ORFkType $certificateOperation
     * @param ORFkType $authenticationMode
     * @param ORFkType $keySize
     * @param ORFkType $deviceMobilityMode
     * @param ORFkType $dndOption
     * @param ORFkType $dndRingSetting
     * @param ORFkType $mobilityUserIdName
     * @param ORFkType $phoneSuite
     * @param ORFkType $phoneServiceDisplay
     * @param ORFkType $mtpPreferedCodec
     * @param ORFkType $dialRulesName
     * @param ORFkType $outboundCallRollover
     * @param ORFkType $alwaysUsePrimeLine
     * @param ORFkType $alwaysUsePrimeLineForVoiceMessage
     * @param ORFkType $featureControlPolicy
     * @param ORFkType $deviceTrustMode
     * @param ConfidentialAccess $confidentialAccess
     * @param ORFkType $cgpnIngressDN
     * @param ORFkType $wifiHotspotProfile
     * @param ORFkType $wirelessLanProfileGroup
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(ORFkType $product = null, ORFkType $class = null, ORFkType $protocol = null, ORFkType $protocolSide = null, ORFkType $callingSearchSpaceName = null, ORFkType $devicePoolName = null, ORFkType $commonDeviceConfigName = null, ORFkType $commonPhoneConfigName = null, ORFkType $networkLocation = null, ORFkType $locationName = null, ORFkType $mediaResourceListName = null, ORFkType $networkHoldMohAudioSourceId = null, ORFkType $userHoldMohAudioSourceId = null, ORFkType $automatedAlternateRoutingCssName = null, ORFkType $aarNeighborhoodName = null, ORFkType $mlppIndicationStatus = null, ORFkType $preemption = null, ORFkType $useTrustedRelayPoint = null, ORFkType $securityProfileName = null, ORFkType $sipProfileName = null, ORFkType $cgpnTransformationCssName = null, ORFkType $geoLocationName = null, ORFkType $geoLocationFilterName = null, Lines $lines = null, ORFkType $phoneTemplateName = null, ORFkType $primaryPhoneName = null, ORFkType $ringSettingIdleBlfAudibleAlert = null, ORFkType $ringSettingBusyBlfAudibleAlert = null, BlfDirectedCallParks $blfDirectedCallParks = null, AddOnModules $addOnModules = null, ORFkType $userLocale = null, ORFkType $networkLocale = null, Services $services = null, ORFkType $softkeyTemplateName = null, ORFkType $defaultProfileName = null, ORFkType $singleButtonBarge = null, ORFkType $joinAcrossLines = null, ORFkType $builtInBridgeStatus = null, ORFkType $callInfoPrivacyStatus = null, ORFkType $ownerUserName = null, ORFkType $packetCaptureMode = null, ORFkType $subscribeCallingSearchSpaceName = null, ORFkType $rerouteCallingSearchSpaceName = null, ORFkType $presenceGroupName = null, ORFkType $certificateOperation = null, ORFkType $authenticationMode = null, ORFkType $keySize = null, ORFkType $deviceMobilityMode = null, ORFkType $dndOption = null, ORFkType $dndRingSetting = null, ORFkType $mobilityUserIdName = null, ORFkType $phoneSuite = null, ORFkType $phoneServiceDisplay = null, ORFkType $mtpPreferedCodec = null, ORFkType $dialRulesName = null, ORFkType $outboundCallRollover = null, ORFkType $alwaysUsePrimeLine = null, ORFkType $alwaysUsePrimeLineForVoiceMessage = null, ORFkType $featureControlPolicy = null, ORFkType $deviceTrustMode = null, ConfidentialAccess $confidentialAccess = null, ORFkType $cgpnIngressDN = null, ORFkType $wifiHotspotProfile = null, ORFkType $wirelessLanProfileGroup = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setLines($lines)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert)
            ->setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setServices($services)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setDefaultProfileName($defaultProfileName)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setBuiltInBridgeStatus($builtInBridgeStatus)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setOwnerUserName($ownerUserName)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setPresenceGroupName($presenceGroupName)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setMobilityUserIdName($mobilityUserIdName)
            ->setPhoneSuite($phoneSuite)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setMtpPreferedCodec($mtpPreferedCodec)
            ->setDialRulesName($dialRulesName)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setDeviceTrustMode($deviceTrustMode)
            ->setConfidentialAccess($confidentialAccess)
            ->setCgpnIngressDN($cgpnIngressDN)
            ->setWifiHotspotProfile($wifiHotspotProfile)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get product value
     * @return ORFkType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param ORFkType $product
     * @return ORPhone
     */
    public function setProduct(ORFkType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return ORFkType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param ORFkType $class
     * @return ORPhone
     */
    public function setClass(ORFkType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return ORFkType|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param ORFkType $protocol
     * @return ORPhone
     */
    public function setProtocol(ORFkType $protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return ORFkType|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param ORFkType $protocolSide
     * @return ORPhone
     */
    public function setProtocolSide(ORFkType $protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return ORFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param ORFkType $callingSearchSpaceName
     * @return ORPhone
     */
    public function setCallingSearchSpaceName(ORFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return ORFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param ORFkType $devicePoolName
     * @return ORPhone
     */
    public function setDevicePoolName(ORFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return ORFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param ORFkType $commonDeviceConfigName
     * @return ORPhone
     */
    public function setCommonDeviceConfigName(ORFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return ORFkType|null
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param ORFkType $commonPhoneConfigName
     * @return ORPhone
     */
    public function setCommonPhoneConfigName(ORFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return ORFkType|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param ORFkType $networkLocation
     * @return ORPhone
     */
    public function setNetworkLocation(ORFkType $networkLocation = null)
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return ORFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param ORFkType $locationName
     * @return ORPhone
     */
    public function setLocationName(ORFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return ORFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param ORFkType $mediaResourceListName
     * @return ORPhone
     */
    public function setMediaResourceListName(ORFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return ORFkType|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param ORFkType $networkHoldMohAudioSourceId
     * @return ORPhone
     */
    public function setNetworkHoldMohAudioSourceId(ORFkType $networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return ORFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param ORFkType $userHoldMohAudioSourceId
     * @return ORPhone
     */
    public function setUserHoldMohAudioSourceId(ORFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return ORFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param ORFkType $automatedAlternateRoutingCssName
     * @return ORPhone
     */
    public function setAutomatedAlternateRoutingCssName(ORFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return ORFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param ORFkType $aarNeighborhoodName
     * @return ORPhone
     */
    public function setAarNeighborhoodName(ORFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return ORFkType|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param ORFkType $mlppIndicationStatus
     * @return ORPhone
     */
    public function setMlppIndicationStatus(ORFkType $mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return ORFkType|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param ORFkType $preemption
     * @return ORPhone
     */
    public function setPreemption(ORFkType $preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return ORFkType|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param ORFkType $useTrustedRelayPoint
     * @return ORPhone
     */
    public function setUseTrustedRelayPoint(ORFkType $useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return ORFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param ORFkType $securityProfileName
     * @return ORPhone
     */
    public function setSecurityProfileName(ORFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return ORFkType|null
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param ORFkType $sipProfileName
     * @return ORPhone
     */
    public function setSipProfileName(ORFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return ORFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param ORFkType $cgpnTransformationCssName
     * @return ORPhone
     */
    public function setCgpnTransformationCssName(ORFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return ORFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param ORFkType $geoLocationName
     * @return ORPhone
     */
    public function setGeoLocationName(ORFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return ORFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param ORFkType $geoLocationFilterName
     * @return ORPhone
     */
    public function setGeoLocationFilterName(ORFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get lines value
     * @return Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param Lines $lines
     * @return ORPhone
     */
    public function setLines(Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return ORFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param ORFkType $phoneTemplateName
     * @return ORPhone
     */
    public function setPhoneTemplateName(ORFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * @return ORFkType|null
     */
    public function getPrimaryPhoneName()
    {
        return $this->primaryPhoneName;
    }
    /**
     * Set primaryPhoneName value
     * @param ORFkType $primaryPhoneName
     * @return ORPhone
     */
    public function setPrimaryPhoneName(ORFkType $primaryPhoneName = null)
    {
        $this->primaryPhoneName = $primaryPhoneName;
        return $this;
    }
    /**
     * Get ringSettingIdleBlfAudibleAlert value
     * @return ORFkType|null
     */
    public function getRingSettingIdleBlfAudibleAlert()
    {
        return $this->ringSettingIdleBlfAudibleAlert;
    }
    /**
     * Set ringSettingIdleBlfAudibleAlert value
     * @param ORFkType $ringSettingIdleBlfAudibleAlert
     * @return ORPhone
     */
    public function setRingSettingIdleBlfAudibleAlert(ORFkType $ringSettingIdleBlfAudibleAlert = null)
    {
        $this->ringSettingIdleBlfAudibleAlert = $ringSettingIdleBlfAudibleAlert;
        return $this;
    }
    /**
     * Get ringSettingBusyBlfAudibleAlert value
     * @return ORFkType|null
     */
    public function getRingSettingBusyBlfAudibleAlert()
    {
        return $this->ringSettingBusyBlfAudibleAlert;
    }
    /**
     * Set ringSettingBusyBlfAudibleAlert value
     * @param ORFkType $ringSettingBusyBlfAudibleAlert
     * @return ORPhone
     */
    public function setRingSettingBusyBlfAudibleAlert(ORFkType $ringSettingBusyBlfAudibleAlert = null)
    {
        $this->ringSettingBusyBlfAudibleAlert = $ringSettingBusyBlfAudibleAlert;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @return ORPhone
     */
    public function setBlfDirectedCallParks(BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param AddOnModules $addOnModules
     * @return ORPhone
     */
    public function setAddOnModules(AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return ORFkType|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param ORFkType $userLocale
     * @return ORPhone
     */
    public function setUserLocale(ORFkType $userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return ORFkType|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @param ORFkType $networkLocale
     * @return ORPhone
     */
    public function setNetworkLocale(ORFkType $networkLocale = null)
    {
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get services value
     * @return Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param Services $services
     * @return ORPhone
     */
    public function setServices(Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return ORFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param ORFkType $softkeyTemplateName
     * @return ORPhone
     */
    public function setSoftkeyTemplateName(ORFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get defaultProfileName value
     * @return ORFkType|null
     */
    public function getDefaultProfileName()
    {
        return $this->defaultProfileName;
    }
    /**
     * Set defaultProfileName value
     * @param ORFkType $defaultProfileName
     * @return ORPhone
     */
    public function setDefaultProfileName(ORFkType $defaultProfileName = null)
    {
        $this->defaultProfileName = $defaultProfileName;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return ORFkType|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param ORFkType $singleButtonBarge
     * @return ORPhone
     */
    public function setSingleButtonBarge(ORFkType $singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return ORFkType|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param ORFkType $joinAcrossLines
     * @return ORPhone
     */
    public function setJoinAcrossLines(ORFkType $joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get builtInBridgeStatus value
     * @return ORFkType|null
     */
    public function getBuiltInBridgeStatus()
    {
        return $this->builtInBridgeStatus;
    }
    /**
     * Set builtInBridgeStatus value
     * @param ORFkType $builtInBridgeStatus
     * @return ORPhone
     */
    public function setBuiltInBridgeStatus(ORFkType $builtInBridgeStatus = null)
    {
        $this->builtInBridgeStatus = $builtInBridgeStatus;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return ORFkType|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param ORFkType $callInfoPrivacyStatus
     * @return ORPhone
     */
    public function setCallInfoPrivacyStatus(ORFkType $callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * @return ORFkType|null
     */
    public function getOwnerUserName()
    {
        return $this->ownerUserName;
    }
    /**
     * Set ownerUserName value
     * @param ORFkType $ownerUserName
     * @return ORPhone
     */
    public function setOwnerUserName(ORFkType $ownerUserName = null)
    {
        $this->ownerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return ORFkType|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param ORFkType $packetCaptureMode
     * @return ORPhone
     */
    public function setPacketCaptureMode(ORFkType $packetCaptureMode = null)
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return ORFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param ORFkType $subscribeCallingSearchSpaceName
     * @return ORPhone
     */
    public function setSubscribeCallingSearchSpaceName(ORFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * @return ORFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return $this->rerouteCallingSearchSpaceName;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * @param ORFkType $rerouteCallingSearchSpaceName
     * @return ORPhone
     */
    public function setRerouteCallingSearchSpaceName(ORFkType $rerouteCallingSearchSpaceName = null)
    {
        $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return ORFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param ORFkType $presenceGroupName
     * @return ORPhone
     */
    public function setPresenceGroupName(ORFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return ORFkType|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @param ORFkType $certificateOperation
     * @return ORPhone
     */
    public function setCertificateOperation(ORFkType $certificateOperation = null)
    {
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return ORFkType|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @param ORFkType $authenticationMode
     * @return ORPhone
     */
    public function setAuthenticationMode(ORFkType $authenticationMode = null)
    {
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return ORFkType|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @param ORFkType $keySize
     * @return ORPhone
     */
    public function setKeySize(ORFkType $keySize = null)
    {
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return ORFkType|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @param ORFkType $deviceMobilityMode
     * @return ORPhone
     */
    public function setDeviceMobilityMode(ORFkType $deviceMobilityMode = null)
    {
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get dndOption value
     * @return ORFkType|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param ORFkType $dndOption
     * @return ORPhone
     */
    public function setDndOption(ORFkType $dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return ORFkType|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param ORFkType $dndRingSetting
     * @return ORPhone
     */
    public function setDndRingSetting(ORFkType $dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get mobilityUserIdName value
     * @return ORFkType|null
     */
    public function getMobilityUserIdName()
    {
        return $this->mobilityUserIdName;
    }
    /**
     * Set mobilityUserIdName value
     * @param ORFkType $mobilityUserIdName
     * @return ORPhone
     */
    public function setMobilityUserIdName(ORFkType $mobilityUserIdName = null)
    {
        $this->mobilityUserIdName = $mobilityUserIdName;
        return $this;
    }
    /**
     * Get phoneSuite value
     * @return ORFkType|null
     */
    public function getPhoneSuite()
    {
        return $this->phoneSuite;
    }
    /**
     * Set phoneSuite value
     * @param ORFkType $phoneSuite
     * @return ORPhone
     */
    public function setPhoneSuite(ORFkType $phoneSuite = null)
    {
        $this->phoneSuite = $phoneSuite;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return ORFkType|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @param ORFkType $phoneServiceDisplay
     * @return ORPhone
     */
    public function setPhoneServiceDisplay(ORFkType $phoneServiceDisplay = null)
    {
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get mtpPreferedCodec value
     * @return ORFkType|null
     */
    public function getMtpPreferedCodec()
    {
        return $this->mtpPreferedCodec;
    }
    /**
     * Set mtpPreferedCodec value
     * @param ORFkType $mtpPreferedCodec
     * @return ORPhone
     */
    public function setMtpPreferedCodec(ORFkType $mtpPreferedCodec = null)
    {
        $this->mtpPreferedCodec = $mtpPreferedCodec;
        return $this;
    }
    /**
     * Get dialRulesName value
     * @return ORFkType|null
     */
    public function getDialRulesName()
    {
        return $this->dialRulesName;
    }
    /**
     * Set dialRulesName value
     * @param ORFkType $dialRulesName
     * @return ORPhone
     */
    public function setDialRulesName(ORFkType $dialRulesName = null)
    {
        $this->dialRulesName = $dialRulesName;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return ORFkType|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @param ORFkType $outboundCallRollover
     * @return ORPhone
     */
    public function setOutboundCallRollover(ORFkType $outboundCallRollover = null)
    {
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return ORFkType|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param ORFkType $alwaysUsePrimeLine
     * @return ORPhone
     */
    public function setAlwaysUsePrimeLine(ORFkType $alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return ORFkType|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param ORFkType $alwaysUsePrimeLineForVoiceMessage
     * @return ORPhone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage(ORFkType $alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return ORFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param ORFkType $featureControlPolicy
     * @return ORPhone
     */
    public function setFeatureControlPolicy(ORFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get deviceTrustMode value
     * @return ORFkType|null
     */
    public function getDeviceTrustMode()
    {
        return $this->deviceTrustMode;
    }
    /**
     * Set deviceTrustMode value
     * @param ORFkType $deviceTrustMode
     * @return ORPhone
     */
    public function setDeviceTrustMode(ORFkType $deviceTrustMode = null)
    {
        $this->deviceTrustMode = $deviceTrustMode;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return ORPhone
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get cgpnIngressDN value
     * @return ORFkType|null
     */
    public function getCgpnIngressDN()
    {
        return $this->cgpnIngressDN;
    }
    /**
     * Set cgpnIngressDN value
     * @param ORFkType $cgpnIngressDN
     * @return ORPhone
     */
    public function setCgpnIngressDN(ORFkType $cgpnIngressDN = null)
    {
        $this->cgpnIngressDN = $cgpnIngressDN;
        return $this;
    }
    /**
     * Get wifiHotspotProfile value
     * @return ORFkType|null
     */
    public function getWifiHotspotProfile()
    {
        return $this->wifiHotspotProfile;
    }
    /**
     * Set wifiHotspotProfile value
     * @param ORFkType $wifiHotspotProfile
     * @return ORPhone
     */
    public function setWifiHotspotProfile(ORFkType $wifiHotspotProfile = null)
    {
        $this->wifiHotspotProfile = $wifiHotspotProfile;
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * @return ORFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return $this->wirelessLanProfileGroup;
    }
    /**
     * Set wirelessLanProfileGroup value
     * @param ORFkType $wirelessLanProfileGroup
     * @return ORPhone
     */
    public function setWirelessLanProfileGroup(ORFkType $wirelessLanProfileGroup = null)
    {
        $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return ORPhone
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return ORPhone
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ORPhone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
