<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORLine StructType
 * @subpackage Structs
 */
class ORLine extends AbstractStructBase
{
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $routePartitionName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $aarNeighborhoodName;
    /**
     * The callForwardAll
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardAll
     */
    public $callForwardAll;
    /**
     * The callForwardBusy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardBusy
     */
    public $callForwardBusy;
    /**
     * The callForwardBusyInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardBusyInt
     */
    public $callForwardBusyInt;
    /**
     * The callForwardNoAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardNoAnswer
     */
    public $callForwardNoAnswer;
    /**
     * The callForwardNoAnswerInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardNoAnswerInt
     */
    public $callForwardNoAnswerInt;
    /**
     * The callForwardNoCoverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardNoCoverage
     */
    public $callForwardNoCoverage;
    /**
     * The callForwardNoCoverageInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardNoCoverageInt
     */
    public $callForwardNoCoverageInt;
    /**
     * The callForwardOnFailure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardOnFailure
     */
    public $callForwardOnFailure;
    /**
     * The callForwardAlternateParty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardAlternateParty
     */
    public $callForwardAlternateParty;
    /**
     * The callForwardNotRegistered
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardNotRegistered
     */
    public $callForwardNotRegistered;
    /**
     * The callForwardNotRegisteredInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORCallForwardNotRegisteredInt
     */
    public $callForwardNotRegisteredInt;
    /**
     * The callPickupGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callPickupGroupName;
    /**
     * The autoAnswer
     * Meta informations extracted from the WSDL
     * - documentation: For an intercom line this tag should be treated as a mandatory tag and the valid values are Auto Answer with Headset and Auto Answer with Speakerphone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $autoAnswer;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $presenceGroupName;
    /**
     * The shareLineAppearanceCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $shareLineAppearanceCssName;
    /**
     * The voiceMailProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $voiceMailProfileName;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $releaseClause;
    /**
     * The cfaCssPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $cfaCssPolicy;
    /**
     * The defaultActivatedDeviceName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable for only intercom lines and if not set, intercom lines will not be active.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $defaultActivatedDeviceName;
    /**
     * The parkMonForwardNoRetrieveCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $parkMonForwardNoRetrieveCssName;
    /**
     * The parkMonForwardNoRetrieveIntCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $parkMonForwardNoRetrieveIntCssName;
    /**
     * The partyEntranceTone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $partyEntranceTone;
    /**
     * The directoryURIs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DirectoryURIs
     */
    public $directoryURIs;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The externalCallControlProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $externalCallControlProfile;
    /**
     * The enterpriseAltNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var E164AltNum
     */
    public $e164AltNum;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORLine
     * @uses ORLine::setUsage()
     * @uses ORLine::setRoutePartitionName()
     * @uses ORLine::setAarNeighborhoodName()
     * @uses ORLine::setCallForwardAll()
     * @uses ORLine::setCallForwardBusy()
     * @uses ORLine::setCallForwardBusyInt()
     * @uses ORLine::setCallForwardNoAnswer()
     * @uses ORLine::setCallForwardNoAnswerInt()
     * @uses ORLine::setCallForwardNoCoverage()
     * @uses ORLine::setCallForwardNoCoverageInt()
     * @uses ORLine::setCallForwardOnFailure()
     * @uses ORLine::setCallForwardAlternateParty()
     * @uses ORLine::setCallForwardNotRegistered()
     * @uses ORLine::setCallForwardNotRegisteredInt()
     * @uses ORLine::setCallPickupGroupName()
     * @uses ORLine::setAutoAnswer()
     * @uses ORLine::setNetworkHoldMohAudioSourceId()
     * @uses ORLine::setUserHoldMohAudioSourceId()
     * @uses ORLine::setPresenceGroupName()
     * @uses ORLine::setShareLineAppearanceCssName()
     * @uses ORLine::setVoiceMailProfileName()
     * @uses ORLine::setPatternPrecedence()
     * @uses ORLine::setReleaseClause()
     * @uses ORLine::setCfaCssPolicy()
     * @uses ORLine::setDefaultActivatedDeviceName()
     * @uses ORLine::setParkMonForwardNoRetrieveCssName()
     * @uses ORLine::setParkMonForwardNoRetrieveIntCssName()
     * @uses ORLine::setPartyEntranceTone()
     * @uses ORLine::setDirectoryURIs()
     * @uses ORLine::setConfidentialAccess()
     * @uses ORLine::setExternalCallControlProfile()
     * @uses ORLine::setEnterpriseAltNum()
     * @uses ORLine::setE164AltNum()
     * @uses ORLine::setUuid()
     * @param ORFkType $usage
     * @param ORFkType $routePartitionName
     * @param ORFkType $aarNeighborhoodName
     * @param ORCallForwardAll $callForwardAll
     * @param ORCallForwardBusy $callForwardBusy
     * @param ORCallForwardBusyInt $callForwardBusyInt
     * @param ORCallForwardNoAnswer $callForwardNoAnswer
     * @param ORCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @param ORCallForwardNoCoverage $callForwardNoCoverage
     * @param ORCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @param ORCallForwardOnFailure $callForwardOnFailure
     * @param ORCallForwardAlternateParty $callForwardAlternateParty
     * @param ORCallForwardNotRegistered $callForwardNotRegistered
     * @param ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @param ORFkType $callPickupGroupName
     * @param ORFkType $autoAnswer
     * @param ORFkType $networkHoldMohAudioSourceId
     * @param ORFkType $userHoldMohAudioSourceId
     * @param ORFkType $presenceGroupName
     * @param ORFkType $shareLineAppearanceCssName
     * @param ORFkType $voiceMailProfileName
     * @param ORFkType $patternPrecedence
     * @param ORFkType $releaseClause
     * @param ORFkType $cfaCssPolicy
     * @param ORFkType $defaultActivatedDeviceName
     * @param ORFkType $parkMonForwardNoRetrieveCssName
     * @param ORFkType $parkMonForwardNoRetrieveIntCssName
     * @param ORFkType $partyEntranceTone
     * @param DirectoryURIs $directoryURIs
     * @param ConfidentialAccess $confidentialAccess
     * @param ORFkType $externalCallControlProfile
     * @param EnterpriseAltNum $enterpriseAltNum
     * @param E164AltNum $e164AltNum
     * @param string $uuid
     */
    public function __construct(ORFkType $usage = null, ORFkType $routePartitionName = null, ORFkType $aarNeighborhoodName = null, ORCallForwardAll $callForwardAll = null, ORCallForwardBusy $callForwardBusy = null, ORCallForwardBusyInt $callForwardBusyInt = null, ORCallForwardNoAnswer $callForwardNoAnswer = null, ORCallForwardNoAnswerInt $callForwardNoAnswerInt = null, ORCallForwardNoCoverage $callForwardNoCoverage = null, ORCallForwardNoCoverageInt $callForwardNoCoverageInt = null, ORCallForwardOnFailure $callForwardOnFailure = null, ORCallForwardAlternateParty $callForwardAlternateParty = null, ORCallForwardNotRegistered $callForwardNotRegistered = null, ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null, ORFkType $callPickupGroupName = null, ORFkType $autoAnswer = null, ORFkType $networkHoldMohAudioSourceId = null, ORFkType $userHoldMohAudioSourceId = null, ORFkType $presenceGroupName = null, ORFkType $shareLineAppearanceCssName = null, ORFkType $voiceMailProfileName = null, ORFkType $patternPrecedence = null, ORFkType $releaseClause = null, ORFkType $cfaCssPolicy = null, ORFkType $defaultActivatedDeviceName = null, ORFkType $parkMonForwardNoRetrieveCssName = null, ORFkType $parkMonForwardNoRetrieveIntCssName = null, ORFkType $partyEntranceTone = null, DirectoryURIs $directoryURIs = null, ConfidentialAccess $confidentialAccess = null, ORFkType $externalCallControlProfile = null, EnterpriseAltNum $enterpriseAltNum = null, E164AltNum $e164AltNum = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setCallForwardAll($callForwardAll)
            ->setCallForwardBusy($callForwardBusy)
            ->setCallForwardBusyInt($callForwardBusyInt)
            ->setCallForwardNoAnswer($callForwardNoAnswer)
            ->setCallForwardNoAnswerInt($callForwardNoAnswerInt)
            ->setCallForwardNoCoverage($callForwardNoCoverage)
            ->setCallForwardNoCoverageInt($callForwardNoCoverageInt)
            ->setCallForwardOnFailure($callForwardOnFailure)
            ->setCallForwardAlternateParty($callForwardAlternateParty)
            ->setCallForwardNotRegistered($callForwardNotRegistered)
            ->setCallForwardNotRegisteredInt($callForwardNotRegisteredInt)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setAutoAnswer($autoAnswer)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setPresenceGroupName($presenceGroupName)
            ->setShareLineAppearanceCssName($shareLineAppearanceCssName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setCfaCssPolicy($cfaCssPolicy)
            ->setDefaultActivatedDeviceName($defaultActivatedDeviceName)
            ->setParkMonForwardNoRetrieveCssName($parkMonForwardNoRetrieveCssName)
            ->setParkMonForwardNoRetrieveIntCssName($parkMonForwardNoRetrieveIntCssName)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setDirectoryURIs($directoryURIs)
            ->setConfidentialAccess($confidentialAccess)
            ->setExternalCallControlProfile($externalCallControlProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return ORFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param ORFkType $usage
     * @return ORLine
     */
    public function setUsage(ORFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return ORFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param ORFkType $routePartitionName
     * @return ORLine
     */
    public function setRoutePartitionName(ORFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return ORFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param ORFkType $aarNeighborhoodName
     * @return ORLine
     */
    public function setAarNeighborhoodName(ORFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get callForwardAll value
     * @return ORCallForwardAll|null
     */
    public function getCallForwardAll()
    {
        return $this->callForwardAll;
    }
    /**
     * Set callForwardAll value
     * @param ORCallForwardAll $callForwardAll
     * @return ORLine
     */
    public function setCallForwardAll(ORCallForwardAll $callForwardAll = null)
    {
        $this->callForwardAll = $callForwardAll;
        return $this;
    }
    /**
     * Get callForwardBusy value
     * @return ORCallForwardBusy|null
     */
    public function getCallForwardBusy()
    {
        return $this->callForwardBusy;
    }
    /**
     * Set callForwardBusy value
     * @param ORCallForwardBusy $callForwardBusy
     * @return ORLine
     */
    public function setCallForwardBusy(ORCallForwardBusy $callForwardBusy = null)
    {
        $this->callForwardBusy = $callForwardBusy;
        return $this;
    }
    /**
     * Get callForwardBusyInt value
     * @return ORCallForwardBusyInt|null
     */
    public function getCallForwardBusyInt()
    {
        return $this->callForwardBusyInt;
    }
    /**
     * Set callForwardBusyInt value
     * @param ORCallForwardBusyInt $callForwardBusyInt
     * @return ORLine
     */
    public function setCallForwardBusyInt(ORCallForwardBusyInt $callForwardBusyInt = null)
    {
        $this->callForwardBusyInt = $callForwardBusyInt;
        return $this;
    }
    /**
     * Get callForwardNoAnswer value
     * @return ORCallForwardNoAnswer|null
     */
    public function getCallForwardNoAnswer()
    {
        return $this->callForwardNoAnswer;
    }
    /**
     * Set callForwardNoAnswer value
     * @param ORCallForwardNoAnswer $callForwardNoAnswer
     * @return ORLine
     */
    public function setCallForwardNoAnswer(ORCallForwardNoAnswer $callForwardNoAnswer = null)
    {
        $this->callForwardNoAnswer = $callForwardNoAnswer;
        return $this;
    }
    /**
     * Get callForwardNoAnswerInt value
     * @return ORCallForwardNoAnswerInt|null
     */
    public function getCallForwardNoAnswerInt()
    {
        return $this->callForwardNoAnswerInt;
    }
    /**
     * Set callForwardNoAnswerInt value
     * @param ORCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @return ORLine
     */
    public function setCallForwardNoAnswerInt(ORCallForwardNoAnswerInt $callForwardNoAnswerInt = null)
    {
        $this->callForwardNoAnswerInt = $callForwardNoAnswerInt;
        return $this;
    }
    /**
     * Get callForwardNoCoverage value
     * @return ORCallForwardNoCoverage|null
     */
    public function getCallForwardNoCoverage()
    {
        return $this->callForwardNoCoverage;
    }
    /**
     * Set callForwardNoCoverage value
     * @param ORCallForwardNoCoverage $callForwardNoCoverage
     * @return ORLine
     */
    public function setCallForwardNoCoverage(ORCallForwardNoCoverage $callForwardNoCoverage = null)
    {
        $this->callForwardNoCoverage = $callForwardNoCoverage;
        return $this;
    }
    /**
     * Get callForwardNoCoverageInt value
     * @return ORCallForwardNoCoverageInt|null
     */
    public function getCallForwardNoCoverageInt()
    {
        return $this->callForwardNoCoverageInt;
    }
    /**
     * Set callForwardNoCoverageInt value
     * @param ORCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @return ORLine
     */
    public function setCallForwardNoCoverageInt(ORCallForwardNoCoverageInt $callForwardNoCoverageInt = null)
    {
        $this->callForwardNoCoverageInt = $callForwardNoCoverageInt;
        return $this;
    }
    /**
     * Get callForwardOnFailure value
     * @return ORCallForwardOnFailure|null
     */
    public function getCallForwardOnFailure()
    {
        return $this->callForwardOnFailure;
    }
    /**
     * Set callForwardOnFailure value
     * @param ORCallForwardOnFailure $callForwardOnFailure
     * @return ORLine
     */
    public function setCallForwardOnFailure(ORCallForwardOnFailure $callForwardOnFailure = null)
    {
        $this->callForwardOnFailure = $callForwardOnFailure;
        return $this;
    }
    /**
     * Get callForwardAlternateParty value
     * @return ORCallForwardAlternateParty|null
     */
    public function getCallForwardAlternateParty()
    {
        return $this->callForwardAlternateParty;
    }
    /**
     * Set callForwardAlternateParty value
     * @param ORCallForwardAlternateParty $callForwardAlternateParty
     * @return ORLine
     */
    public function setCallForwardAlternateParty(ORCallForwardAlternateParty $callForwardAlternateParty = null)
    {
        $this->callForwardAlternateParty = $callForwardAlternateParty;
        return $this;
    }
    /**
     * Get callForwardNotRegistered value
     * @return ORCallForwardNotRegistered|null
     */
    public function getCallForwardNotRegistered()
    {
        return $this->callForwardNotRegistered;
    }
    /**
     * Set callForwardNotRegistered value
     * @param ORCallForwardNotRegistered $callForwardNotRegistered
     * @return ORLine
     */
    public function setCallForwardNotRegistered(ORCallForwardNotRegistered $callForwardNotRegistered = null)
    {
        $this->callForwardNotRegistered = $callForwardNotRegistered;
        return $this;
    }
    /**
     * Get callForwardNotRegisteredInt value
     * @return ORCallForwardNotRegisteredInt|null
     */
    public function getCallForwardNotRegisteredInt()
    {
        return $this->callForwardNotRegisteredInt;
    }
    /**
     * Set callForwardNotRegisteredInt value
     * @param ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @return ORLine
     */
    public function setCallForwardNotRegisteredInt(ORCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null)
    {
        $this->callForwardNotRegisteredInt = $callForwardNotRegisteredInt;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return ORFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param ORFkType $callPickupGroupName
     * @return ORLine
     */
    public function setCallPickupGroupName(ORFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return ORFkType|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @param ORFkType $autoAnswer
     * @return ORLine
     */
    public function setAutoAnswer(ORFkType $autoAnswer = null)
    {
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return ORFkType|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param ORFkType $networkHoldMohAudioSourceId
     * @return ORLine
     */
    public function setNetworkHoldMohAudioSourceId(ORFkType $networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return ORFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param ORFkType $userHoldMohAudioSourceId
     * @return ORLine
     */
    public function setUserHoldMohAudioSourceId(ORFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return ORFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param ORFkType $presenceGroupName
     * @return ORLine
     */
    public function setPresenceGroupName(ORFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get shareLineAppearanceCssName value
     * @return ORFkType|null
     */
    public function getShareLineAppearanceCssName()
    {
        return $this->shareLineAppearanceCssName;
    }
    /**
     * Set shareLineAppearanceCssName value
     * @param ORFkType $shareLineAppearanceCssName
     * @return ORLine
     */
    public function setShareLineAppearanceCssName(ORFkType $shareLineAppearanceCssName = null)
    {
        $this->shareLineAppearanceCssName = $shareLineAppearanceCssName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return ORFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param ORFkType $voiceMailProfileName
     * @return ORLine
     */
    public function setVoiceMailProfileName(ORFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return ORFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param ORFkType $patternPrecedence
     * @return ORLine
     */
    public function setPatternPrecedence(ORFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return ORFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param ORFkType $releaseClause
     * @return ORLine
     */
    public function setReleaseClause(ORFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get cfaCssPolicy value
     * @return ORFkType|null
     */
    public function getCfaCssPolicy()
    {
        return $this->cfaCssPolicy;
    }
    /**
     * Set cfaCssPolicy value
     * @param ORFkType $cfaCssPolicy
     * @return ORLine
     */
    public function setCfaCssPolicy(ORFkType $cfaCssPolicy = null)
    {
        $this->cfaCssPolicy = $cfaCssPolicy;
        return $this;
    }
    /**
     * Get defaultActivatedDeviceName value
     * @return ORFkType|null
     */
    public function getDefaultActivatedDeviceName()
    {
        return $this->defaultActivatedDeviceName;
    }
    /**
     * Set defaultActivatedDeviceName value
     * @param ORFkType $defaultActivatedDeviceName
     * @return ORLine
     */
    public function setDefaultActivatedDeviceName(ORFkType $defaultActivatedDeviceName = null)
    {
        $this->defaultActivatedDeviceName = $defaultActivatedDeviceName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveCssName value
     * @return ORFkType|null
     */
    public function getParkMonForwardNoRetrieveCssName()
    {
        return $this->parkMonForwardNoRetrieveCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveCssName value
     * @param ORFkType $parkMonForwardNoRetrieveCssName
     * @return ORLine
     */
    public function setParkMonForwardNoRetrieveCssName(ORFkType $parkMonForwardNoRetrieveCssName = null)
    {
        $this->parkMonForwardNoRetrieveCssName = $parkMonForwardNoRetrieveCssName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntCssName value
     * @return ORFkType|null
     */
    public function getParkMonForwardNoRetrieveIntCssName()
    {
        return $this->parkMonForwardNoRetrieveIntCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveIntCssName value
     * @param ORFkType $parkMonForwardNoRetrieveIntCssName
     * @return ORLine
     */
    public function setParkMonForwardNoRetrieveIntCssName(ORFkType $parkMonForwardNoRetrieveIntCssName = null)
    {
        $this->parkMonForwardNoRetrieveIntCssName = $parkMonForwardNoRetrieveIntCssName;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return ORFkType|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @param ORFkType $partyEntranceTone
     * @return ORLine
     */
    public function setPartyEntranceTone(ORFkType $partyEntranceTone = null)
    {
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get directoryURIs value
     * @return DirectoryURIs|null
     */
    public function getDirectoryURIs()
    {
        return $this->directoryURIs;
    }
    /**
     * Set directoryURIs value
     * @param DirectoryURIs $directoryURIs
     * @return ORLine
     */
    public function setDirectoryURIs(DirectoryURIs $directoryURIs = null)
    {
        $this->directoryURIs = $directoryURIs;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return ORLine
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get externalCallControlProfile value
     * @return ORFkType|null
     */
    public function getExternalCallControlProfile()
    {
        return $this->externalCallControlProfile;
    }
    /**
     * Set externalCallControlProfile value
     * @param ORFkType $externalCallControlProfile
     * @return ORLine
     */
    public function setExternalCallControlProfile(ORFkType $externalCallControlProfile = null)
    {
        $this->externalCallControlProfile = $externalCallControlProfile;
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param EnterpriseAltNum $enterpriseAltNum
     * @return ORLine
     */
    public function setEnterpriseAltNum(EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param E164AltNum $e164AltNum
     * @return ORLine
     */
    public function setE164AltNum(E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return ORLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ORLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
