<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORDeviceProfile StructType
 * @subpackage Structs
 */
class ORDeviceProfile extends AbstractStructBase
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $protocolSide;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $preemption;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Lines
     */
    public $lines;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $phoneTemplateName;
    /**
     * The blfDirectedCallParks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $userLocale;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $joinAcrossLines;
    /**
     * The loginUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $loginUserId;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $dndRingSetting;
    /**
     * The emccCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $emccCallingSearchSpace;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $softkeyTemplateName;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callInfoPrivacyStatus;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Services
     */
    public $services;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $featureControlPolicy;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORDeviceProfile
     * @uses ORDeviceProfile::setProduct()
     * @uses ORDeviceProfile::setClass()
     * @uses ORDeviceProfile::setProtocol()
     * @uses ORDeviceProfile::setProtocolSide()
     * @uses ORDeviceProfile::setUserHoldMohAudioSourceId()
     * @uses ORDeviceProfile::setMlppIndicationStatus()
     * @uses ORDeviceProfile::setPreemption()
     * @uses ORDeviceProfile::setLines()
     * @uses ORDeviceProfile::setPhoneTemplateName()
     * @uses ORDeviceProfile::setBlfDirectedCallParks()
     * @uses ORDeviceProfile::setAddOnModules()
     * @uses ORDeviceProfile::setUserLocale()
     * @uses ORDeviceProfile::setSingleButtonBarge()
     * @uses ORDeviceProfile::setJoinAcrossLines()
     * @uses ORDeviceProfile::setLoginUserId()
     * @uses ORDeviceProfile::setDndOption()
     * @uses ORDeviceProfile::setDndRingSetting()
     * @uses ORDeviceProfile::setEmccCallingSearchSpace()
     * @uses ORDeviceProfile::setAlwaysUsePrimeLine()
     * @uses ORDeviceProfile::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses ORDeviceProfile::setSoftkeyTemplateName()
     * @uses ORDeviceProfile::setCallInfoPrivacyStatus()
     * @uses ORDeviceProfile::setServices()
     * @uses ORDeviceProfile::setFeatureControlPolicy()
     * @uses ORDeviceProfile::setCtiid()
     * @uses ORDeviceProfile::setUuid()
     * @param ORFkType $product
     * @param ORFkType $class
     * @param ORFkType $protocol
     * @param ORFkType $protocolSide
     * @param ORFkType $userHoldMohAudioSourceId
     * @param ORFkType $mlppIndicationStatus
     * @param ORFkType $preemption
     * @param Lines $lines
     * @param ORFkType $phoneTemplateName
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @param AddOnModules $addOnModules
     * @param ORFkType $userLocale
     * @param ORFkType $singleButtonBarge
     * @param ORFkType $joinAcrossLines
     * @param ORFkType $loginUserId
     * @param ORFkType $dndOption
     * @param ORFkType $dndRingSetting
     * @param ORFkType $emccCallingSearchSpace
     * @param ORFkType $alwaysUsePrimeLine
     * @param ORFkType $alwaysUsePrimeLineForVoiceMessage
     * @param ORFkType $softkeyTemplateName
     * @param ORFkType $callInfoPrivacyStatus
     * @param Services $services
     * @param ORFkType $featureControlPolicy
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(ORFkType $product = null, ORFkType $class = null, ORFkType $protocol = null, ORFkType $protocolSide = null, ORFkType $userHoldMohAudioSourceId = null, ORFkType $mlppIndicationStatus = null, ORFkType $preemption = null, Lines $lines = null, ORFkType $phoneTemplateName = null, BlfDirectedCallParks $blfDirectedCallParks = null, AddOnModules $addOnModules = null, ORFkType $userLocale = null, ORFkType $singleButtonBarge = null, ORFkType $joinAcrossLines = null, ORFkType $loginUserId = null, ORFkType $dndOption = null, ORFkType $dndRingSetting = null, ORFkType $emccCallingSearchSpace = null, ORFkType $alwaysUsePrimeLine = null, ORFkType $alwaysUsePrimeLineForVoiceMessage = null, ORFkType $softkeyTemplateName = null, ORFkType $callInfoPrivacyStatus = null, Services $services = null, ORFkType $featureControlPolicy = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setLines($lines)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setLoginUserId($loginUserId)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setEmccCallingSearchSpace($emccCallingSearchSpace)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setServices($services)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get product value
     * @return ORFkType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param ORFkType $product
     * @return ORDeviceProfile
     */
    public function setProduct(ORFkType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return ORFkType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param ORFkType $class
     * @return ORDeviceProfile
     */
    public function setClass(ORFkType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return ORFkType|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param ORFkType $protocol
     * @return ORDeviceProfile
     */
    public function setProtocol(ORFkType $protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return ORFkType|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param ORFkType $protocolSide
     * @return ORDeviceProfile
     */
    public function setProtocolSide(ORFkType $protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return ORFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param ORFkType $userHoldMohAudioSourceId
     * @return ORDeviceProfile
     */
    public function setUserHoldMohAudioSourceId(ORFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return ORFkType|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param ORFkType $mlppIndicationStatus
     * @return ORDeviceProfile
     */
    public function setMlppIndicationStatus(ORFkType $mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return ORFkType|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param ORFkType $preemption
     * @return ORDeviceProfile
     */
    public function setPreemption(ORFkType $preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get lines value
     * @return Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param Lines $lines
     * @return ORDeviceProfile
     */
    public function setLines(Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return ORFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param ORFkType $phoneTemplateName
     * @return ORDeviceProfile
     */
    public function setPhoneTemplateName(ORFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @return ORDeviceProfile
     */
    public function setBlfDirectedCallParks(BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param AddOnModules $addOnModules
     * @return ORDeviceProfile
     */
    public function setAddOnModules(AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return ORFkType|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param ORFkType $userLocale
     * @return ORDeviceProfile
     */
    public function setUserLocale(ORFkType $userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return ORFkType|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param ORFkType $singleButtonBarge
     * @return ORDeviceProfile
     */
    public function setSingleButtonBarge(ORFkType $singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return ORFkType|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param ORFkType $joinAcrossLines
     * @return ORDeviceProfile
     */
    public function setJoinAcrossLines(ORFkType $joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get loginUserId value
     * @return ORFkType|null
     */
    public function getLoginUserId()
    {
        return $this->loginUserId;
    }
    /**
     * Set loginUserId value
     * @param ORFkType $loginUserId
     * @return ORDeviceProfile
     */
    public function setLoginUserId(ORFkType $loginUserId = null)
    {
        $this->loginUserId = $loginUserId;
        return $this;
    }
    /**
     * Get dndOption value
     * @return ORFkType|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param ORFkType $dndOption
     * @return ORDeviceProfile
     */
    public function setDndOption(ORFkType $dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return ORFkType|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param ORFkType $dndRingSetting
     * @return ORDeviceProfile
     */
    public function setDndRingSetting(ORFkType $dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get emccCallingSearchSpace value
     * @return ORFkType|null
     */
    public function getEmccCallingSearchSpace()
    {
        return $this->emccCallingSearchSpace;
    }
    /**
     * Set emccCallingSearchSpace value
     * @param ORFkType $emccCallingSearchSpace
     * @return ORDeviceProfile
     */
    public function setEmccCallingSearchSpace(ORFkType $emccCallingSearchSpace = null)
    {
        $this->emccCallingSearchSpace = $emccCallingSearchSpace;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return ORFkType|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param ORFkType $alwaysUsePrimeLine
     * @return ORDeviceProfile
     */
    public function setAlwaysUsePrimeLine(ORFkType $alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return ORFkType|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param ORFkType $alwaysUsePrimeLineForVoiceMessage
     * @return ORDeviceProfile
     */
    public function setAlwaysUsePrimeLineForVoiceMessage(ORFkType $alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return ORFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param ORFkType $softkeyTemplateName
     * @return ORDeviceProfile
     */
    public function setSoftkeyTemplateName(ORFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return ORFkType|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param ORFkType $callInfoPrivacyStatus
     * @return ORDeviceProfile
     */
    public function setCallInfoPrivacyStatus(ORFkType $callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get services value
     * @return Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param Services $services
     * @return ORDeviceProfile
     */
    public function setServices(Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return ORFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param ORFkType $featureControlPolicy
     * @return ORDeviceProfile
     */
    public function setFeatureControlPolicy(ORFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return ORDeviceProfile
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return ORDeviceProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ORDeviceProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
