<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LGatewayEndpointDigitalT1 StructType
 * @subpackage Structs
 */
class LGatewayEndpointDigitalT1 extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocationName;
    /**
     * The sendGeoLocation
     * Meta informations extracted from the WSDL
     * - documentation: Not valid for CTI route points and VoiceMail ports
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The v150
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $v150;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocationFilterName;
    /**
     * The ports
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Ports
     */
    public $ports;
    /**
     * The trunkSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkSelectionOrder;
    /**
     * The clockReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clockReference;
    /**
     * The csuParam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $csuParam;
    /**
     * The digitSending
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digitSending;
    /**
     * The pcmType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pcmType;
    /**
     * The fdlChannel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fdlChannel;
    /**
     * The yellowAlarm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $yellowAlarm;
    /**
     * The zeroSupression
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zeroSupression;
    /**
     * The smdiBasePort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $smdiBasePort;
    /**
     * The handleDtmfPrecedenceSignals
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $handleDtmfPrecedenceSignals;
    /**
     * The encodeOutboundVoiceRouteClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $encodeOutboundVoiceRouteClass;
    /**
     * The routeClassSignalling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routeClassSignalling;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $imeE164TransformationName;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LGatewayEndpointDigitalT1
     * @uses LGatewayEndpointDigitalT1::setIndex()
     * @uses LGatewayEndpointDigitalT1::setName()
     * @uses LGatewayEndpointDigitalT1::setDescription()
     * @uses LGatewayEndpointDigitalT1::setProduct()
     * @uses LGatewayEndpointDigitalT1::setModel()
     * @uses LGatewayEndpointDigitalT1::setClass()
     * @uses LGatewayEndpointDigitalT1::setProtocol()
     * @uses LGatewayEndpointDigitalT1::setProtocolSide()
     * @uses LGatewayEndpointDigitalT1::setCallingSearchSpaceName()
     * @uses LGatewayEndpointDigitalT1::setDevicePoolName()
     * @uses LGatewayEndpointDigitalT1::setCommonDeviceConfigName()
     * @uses LGatewayEndpointDigitalT1::setNetworkLocation()
     * @uses LGatewayEndpointDigitalT1::setLocationName()
     * @uses LGatewayEndpointDigitalT1::setMediaResourceListName()
     * @uses LGatewayEndpointDigitalT1::setAutomatedAlternateRoutingCssName()
     * @uses LGatewayEndpointDigitalT1::setAarNeighborhoodName()
     * @uses LGatewayEndpointDigitalT1::setLoadInformation()
     * @uses LGatewayEndpointDigitalT1::setVendorConfig()
     * @uses LGatewayEndpointDigitalT1::setTraceFlag()
     * @uses LGatewayEndpointDigitalT1::setMlppDomainId()
     * @uses LGatewayEndpointDigitalT1::setMlppIndicationStatus()
     * @uses LGatewayEndpointDigitalT1::setPreemption()
     * @uses LGatewayEndpointDigitalT1::setUseTrustedRelayPoint()
     * @uses LGatewayEndpointDigitalT1::setRetryVideoCallAsAudio()
     * @uses LGatewayEndpointDigitalT1::setCgpnTransformationCssName()
     * @uses LGatewayEndpointDigitalT1::setUseDevicePoolCgpnTransformCss()
     * @uses LGatewayEndpointDigitalT1::setGeoLocationName()
     * @uses LGatewayEndpointDigitalT1::setSendGeoLocation()
     * @uses LGatewayEndpointDigitalT1::setCdpnTransformationCssName()
     * @uses LGatewayEndpointDigitalT1::setUseDevicePoolCdpnTransformCss()
     * @uses LGatewayEndpointDigitalT1::setV150()
     * @uses LGatewayEndpointDigitalT1::setGeoLocationFilterName()
     * @uses LGatewayEndpointDigitalT1::setPorts()
     * @uses LGatewayEndpointDigitalT1::setTrunkSelectionOrder()
     * @uses LGatewayEndpointDigitalT1::setClockReference()
     * @uses LGatewayEndpointDigitalT1::setCsuParam()
     * @uses LGatewayEndpointDigitalT1::setDigitSending()
     * @uses LGatewayEndpointDigitalT1::setPcmType()
     * @uses LGatewayEndpointDigitalT1::setFdlChannel()
     * @uses LGatewayEndpointDigitalT1::setYellowAlarm()
     * @uses LGatewayEndpointDigitalT1::setZeroSupression()
     * @uses LGatewayEndpointDigitalT1::setSmdiBasePort()
     * @uses LGatewayEndpointDigitalT1::setHandleDtmfPrecedenceSignals()
     * @uses LGatewayEndpointDigitalT1::setEncodeOutboundVoiceRouteClass()
     * @uses LGatewayEndpointDigitalT1::setRouteClassSignalling()
     * @uses LGatewayEndpointDigitalT1::setPstnAccess()
     * @uses LGatewayEndpointDigitalT1::setImeE164TransformationName()
     * @uses LGatewayEndpointDigitalT1::setConfidentialAccess()
     * @uses LGatewayEndpointDigitalT1::setCtiid()
     * @uses LGatewayEndpointDigitalT1::setUuid()
     * @param string $index
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param XFkType $callingSearchSpaceName
     * @param XFkType $devicePoolName
     * @param XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param XFkType $locationName
     * @param XFkType $mediaResourceListName
     * @param XFkType $automatedAlternateRoutingCssName
     * @param XFkType $aarNeighborhoodName
     * @param XLoadInformation $loadInformation
     * @param XVendorConfig $vendorConfig
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param XFkType $geoLocationName
     * @param string $sendGeoLocation
     * @param XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $v150
     * @param XFkType $geoLocationFilterName
     * @param Ports $ports
     * @param string $trunkSelectionOrder
     * @param string $clockReference
     * @param string $csuParam
     * @param string $digitSending
     * @param string $pcmType
     * @param string $fdlChannel
     * @param string $yellowAlarm
     * @param string $zeroSupression
     * @param string $smdiBasePort
     * @param string $handleDtmfPrecedenceSignals
     * @param string $encodeOutboundVoiceRouteClass
     * @param string $routeClassSignalling
     * @param string $pstnAccess
     * @param XFkType $imeE164TransformationName
     * @param ConfidentialAccess $confidentialAccess
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($index = null, $name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, XFkType $callingSearchSpaceName = null, XFkType $devicePoolName = null, XFkType $commonDeviceConfigName = null, $networkLocation = null, XFkType $locationName = null, XFkType $mediaResourceListName = null, XFkType $automatedAlternateRoutingCssName = null, XFkType $aarNeighborhoodName = null, XLoadInformation $loadInformation = null, XVendorConfig $vendorConfig = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = null, $preemption = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, XFkType $geoLocationName = null, $sendGeoLocation = null, XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, $v150 = null, XFkType $geoLocationFilterName = null, Ports $ports = null, $trunkSelectionOrder = null, $clockReference = null, $csuParam = null, $digitSending = null, $pcmType = null, $fdlChannel = null, $yellowAlarm = null, $zeroSupression = null, $smdiBasePort = null, $handleDtmfPrecedenceSignals = null, $encodeOutboundVoiceRouteClass = null, $routeClassSignalling = null, $pstnAccess = null, XFkType $imeE164TransformationName = null, ConfidentialAccess $confidentialAccess = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setIndex($index)
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setV150($v150)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setPorts($ports)
            ->setTrunkSelectionOrder($trunkSelectionOrder)
            ->setClockReference($clockReference)
            ->setCsuParam($csuParam)
            ->setDigitSending($digitSending)
            ->setPcmType($pcmType)
            ->setFdlChannel($fdlChannel)
            ->setYellowAlarm($yellowAlarm)
            ->setZeroSupression($zeroSupression)
            ->setSmdiBasePort($smdiBasePort)
            ->setHandleDtmfPrecedenceSignals($handleDtmfPrecedenceSignals)
            ->setEncodeOutboundVoiceRouteClass($encodeOutboundVoiceRouteClass)
            ->setRouteClassSignalling($routeClassSignalling)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setConfidentialAccess($confidentialAccess)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return LGatewayEndpointDigitalT1
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LGatewayEndpointDigitalT1
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LGatewayEndpointDigitalT1
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return LGatewayEndpointDigitalT1
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses XModel::valueIsValid()
     * @uses XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return LGatewayEndpointDigitalT1
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses XClass::valueIsValid()
     * @uses XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return LGatewayEndpointDigitalT1
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return LGatewayEndpointDigitalT1
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses XProtocolSide::valueIsValid()
     * @uses XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return LGatewayEndpointDigitalT1
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param XFkType $callingSearchSpaceName
     * @return LGatewayEndpointDigitalT1
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return LGatewayEndpointDigitalT1
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param XFkType $commonDeviceConfigName
     * @return LGatewayEndpointDigitalT1
     */
    public function setCommonDeviceConfigName(XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses XNetworkLocation::valueIsValid()
     * @uses XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return LGatewayEndpointDigitalT1
     */
    public function setNetworkLocation($networkLocation = null)
    {
        // validation for constraint: enumeration
        if (!XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return LGatewayEndpointDigitalT1
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param XFkType $mediaResourceListName
     * @return LGatewayEndpointDigitalT1
     */
    public function setMediaResourceListName(XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param XFkType $automatedAlternateRoutingCssName
     * @return LGatewayEndpointDigitalT1
     */
    public function setAutomatedAlternateRoutingCssName(XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param XFkType $aarNeighborhoodName
     * @return LGatewayEndpointDigitalT1
     */
    public function setAarNeighborhoodName(XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param XLoadInformation $loadInformation
     * @return LGatewayEndpointDigitalT1
     */
    public function setLoadInformation(XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param XVendorConfig $vendorConfig
     * @return LGatewayEndpointDigitalT1
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return LGatewayEndpointDigitalT1
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return LGatewayEndpointDigitalT1
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return LGatewayEndpointDigitalT1
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses XPreemption::valueIsValid()
     * @uses XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return LGatewayEndpointDigitalT1
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return LGatewayEndpointDigitalT1
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return LGatewayEndpointDigitalT1
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param XFkType $cgpnTransformationCssName
     * @return LGatewayEndpointDigitalT1
     */
    public function setCgpnTransformationCssName(XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return LGatewayEndpointDigitalT1
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param XFkType $geoLocationName
     * @return LGatewayEndpointDigitalT1
     */
    public function setGeoLocationName(XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return LGatewayEndpointDigitalT1
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendGeoLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendGeoLocation)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param XFkType $cdpnTransformationCssName
     * @return LGatewayEndpointDigitalT1
     */
    public function setCdpnTransformationCssName(XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return LGatewayEndpointDigitalT1
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get v150 value
     * @return string|null
     */
    public function getV150()
    {
        return $this->v150;
    }
    /**
     * Set v150 value
     * @param string $v150
     * @return LGatewayEndpointDigitalT1
     */
    public function setV150($v150 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($v150) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $v150)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($v150, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($v150) && !is_string($v150)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($v150)), __LINE__);
        }
        $this->v150 = $v150;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param XFkType $geoLocationFilterName
     * @return LGatewayEndpointDigitalT1
     */
    public function setGeoLocationFilterName(XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get ports value
     * @return Ports|null
     */
    public function getPorts()
    {
        return $this->ports;
    }
    /**
     * Set ports value
     * @param Ports $ports
     * @return LGatewayEndpointDigitalT1
     */
    public function setPorts(Ports $ports = null)
    {
        $this->ports = $ports;
        return $this;
    }
    /**
     * Get trunkSelectionOrder value
     * @return string|null
     */
    public function getTrunkSelectionOrder()
    {
        return $this->trunkSelectionOrder;
    }
    /**
     * Set trunkSelectionOrder value
     * @uses XTrunkSelectionOrder::valueIsValid()
     * @uses XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkSelectionOrder
     * @return LGatewayEndpointDigitalT1
     */
    public function setTrunkSelectionOrder($trunkSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!XTrunkSelectionOrder::valueIsValid($trunkSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkSelectionOrder, implode(', ', XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->trunkSelectionOrder = $trunkSelectionOrder;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string|null
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @uses XClockReference::valueIsValid()
     * @uses XClockReference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clockReference
     * @return LGatewayEndpointDigitalT1
     */
    public function setClockReference($clockReference = null)
    {
        // validation for constraint: enumeration
        if (!XClockReference::valueIsValid($clockReference)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $clockReference, implode(', ', XClockReference::getValidValues())), __LINE__);
        }
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string|null
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @uses XCSUParam::valueIsValid()
     * @uses XCSUParam::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $csuParam
     * @return LGatewayEndpointDigitalT1
     */
    public function setCsuParam($csuParam = null)
    {
        // validation for constraint: enumeration
        if (!XCSUParam::valueIsValid($csuParam)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $csuParam, implode(', ', XCSUParam::getValidValues())), __LINE__);
        }
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get digitSending value
     * @return string|null
     */
    public function getDigitSending()
    {
        return $this->digitSending;
    }
    /**
     * Set digitSending value
     * @uses XDigitSending::valueIsValid()
     * @uses XDigitSending::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitSending
     * @return LGatewayEndpointDigitalT1
     */
    public function setDigitSending($digitSending = null)
    {
        // validation for constraint: enumeration
        if (!XDigitSending::valueIsValid($digitSending)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $digitSending, implode(', ', XDigitSending::getValidValues())), __LINE__);
        }
        $this->digitSending = $digitSending;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string|null
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @uses XEncode::valueIsValid()
     * @uses XEncode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pcmType
     * @return LGatewayEndpointDigitalT1
     */
    public function setPcmType($pcmType = null)
    {
        // validation for constraint: enumeration
        if (!XEncode::valueIsValid($pcmType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pcmType, implode(', ', XEncode::getValidValues())), __LINE__);
        }
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get fdlChannel value
     * @return string|null
     */
    public function getFdlChannel()
    {
        return $this->fdlChannel;
    }
    /**
     * Set fdlChannel value
     * @uses XFDLChannel::valueIsValid()
     * @uses XFDLChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fdlChannel
     * @return LGatewayEndpointDigitalT1
     */
    public function setFdlChannel($fdlChannel = null)
    {
        // validation for constraint: enumeration
        if (!XFDLChannel::valueIsValid($fdlChannel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fdlChannel, implode(', ', XFDLChannel::getValidValues())), __LINE__);
        }
        $this->fdlChannel = $fdlChannel;
        return $this;
    }
    /**
     * Get yellowAlarm value
     * @return string|null
     */
    public function getYellowAlarm()
    {
        return $this->yellowAlarm;
    }
    /**
     * Set yellowAlarm value
     * @uses XYellowAlarm::valueIsValid()
     * @uses XYellowAlarm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yellowAlarm
     * @return LGatewayEndpointDigitalT1
     */
    public function setYellowAlarm($yellowAlarm = null)
    {
        // validation for constraint: enumeration
        if (!XYellowAlarm::valueIsValid($yellowAlarm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $yellowAlarm, implode(', ', XYellowAlarm::getValidValues())), __LINE__);
        }
        $this->yellowAlarm = $yellowAlarm;
        return $this;
    }
    /**
     * Get zeroSupression value
     * @return string|null
     */
    public function getZeroSupression()
    {
        return $this->zeroSupression;
    }
    /**
     * Set zeroSupression value
     * @uses XZeroSuppression::valueIsValid()
     * @uses XZeroSuppression::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zeroSupression
     * @return LGatewayEndpointDigitalT1
     */
    public function setZeroSupression($zeroSupression = null)
    {
        // validation for constraint: enumeration
        if (!XZeroSuppression::valueIsValid($zeroSupression)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $zeroSupression, implode(', ', XZeroSuppression::getValidValues())), __LINE__);
        }
        $this->zeroSupression = $zeroSupression;
        return $this;
    }
    /**
     * Get smdiBasePort value
     * @return string|null
     */
    public function getSmdiBasePort()
    {
        return $this->smdiBasePort;
    }
    /**
     * Set smdiBasePort value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $smdiBasePort
     * @return LGatewayEndpointDigitalT1
     */
    public function setSmdiBasePort($smdiBasePort = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($smdiBasePort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $smdiBasePort, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->smdiBasePort = $smdiBasePort;
        return $this;
    }
    /**
     * Get handleDtmfPrecedenceSignals value
     * @return string|null
     */
    public function getHandleDtmfPrecedenceSignals()
    {
        return $this->handleDtmfPrecedenceSignals;
    }
    /**
     * Set handleDtmfPrecedenceSignals value
     * @param string $handleDtmfPrecedenceSignals
     * @return LGatewayEndpointDigitalT1
     */
    public function setHandleDtmfPrecedenceSignals($handleDtmfPrecedenceSignals = null)
    {
        // validation for constraint: pattern
        if (is_scalar($handleDtmfPrecedenceSignals) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $handleDtmfPrecedenceSignals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($handleDtmfPrecedenceSignals, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($handleDtmfPrecedenceSignals) && !is_string($handleDtmfPrecedenceSignals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($handleDtmfPrecedenceSignals)), __LINE__);
        }
        $this->handleDtmfPrecedenceSignals = $handleDtmfPrecedenceSignals;
        return $this;
    }
    /**
     * Get encodeOutboundVoiceRouteClass value
     * @return string|null
     */
    public function getEncodeOutboundVoiceRouteClass()
    {
        return $this->encodeOutboundVoiceRouteClass;
    }
    /**
     * Set encodeOutboundVoiceRouteClass value
     * @param string $encodeOutboundVoiceRouteClass
     * @return LGatewayEndpointDigitalT1
     */
    public function setEncodeOutboundVoiceRouteClass($encodeOutboundVoiceRouteClass = null)
    {
        // validation for constraint: pattern
        if (is_scalar($encodeOutboundVoiceRouteClass) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $encodeOutboundVoiceRouteClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($encodeOutboundVoiceRouteClass, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($encodeOutboundVoiceRouteClass) && !is_string($encodeOutboundVoiceRouteClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encodeOutboundVoiceRouteClass)), __LINE__);
        }
        $this->encodeOutboundVoiceRouteClass = $encodeOutboundVoiceRouteClass;
        return $this;
    }
    /**
     * Get routeClassSignalling value
     * @return string|null
     */
    public function getRouteClassSignalling()
    {
        return $this->routeClassSignalling;
    }
    /**
     * Set routeClassSignalling value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeClassSignalling
     * @return LGatewayEndpointDigitalT1
     */
    public function setRouteClassSignalling($routeClassSignalling = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($routeClassSignalling)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $routeClassSignalling, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->routeClassSignalling = $routeClassSignalling;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return LGatewayEndpointDigitalT1
     */
    public function setPstnAccess($pstnAccess = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param XFkType $imeE164TransformationName
     * @return LGatewayEndpointDigitalT1
     */
    public function setImeE164TransformationName(XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return LGatewayEndpointDigitalT1
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return LGatewayEndpointDigitalT1
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LGatewayEndpointDigitalT1
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LGatewayEndpointDigitalT1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
