<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDhcpSubnet StructType
 * @subpackage Structs
 */
class LDhcpSubnet extends AbstractStructBase
{
    /**
     * The subnetIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subnetIpAddress;
    /**
     * The primaryStartIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primaryStartIpAddress;
    /**
     * The primaryEndIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primaryEndIpAddress;
    /**
     * The secondaryStartIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondaryStartIpAddress;
    /**
     * The secondaryEndIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondaryEndIpAddress;
    /**
     * The primaryRouterIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primaryRouterIpAddress;
    /**
     * The secondaryRouterIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondaryRouterIpAddress;
    /**
     * The subnetMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subnetMask;
    /**
     * The domainName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domainName;
    /**
     * The primaryDnsIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primaryDnsIpAddress;
    /**
     * The secondaryDnsIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondaryDnsIpAddress;
    /**
     * The tftpServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tftpServerName;
    /**
     * The primaryTftpServerIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primaryTftpServerIpAddress;
    /**
     * The secondaryTftpServerIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondaryTftpServerIpAddress;
    /**
     * The bootstrapServerIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bootstrapServerIpAddress;
    /**
     * The arpCacheTimeout
     * Meta informations extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $arpCacheTimeout;
    /**
     * The ipAddressLeaseTime
     * Meta informations extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddressLeaseTime;
    /**
     * The renewalTime
     * Meta informations extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $renewalTime;
    /**
     * The rebindingTime
     * Meta informations extracted from the WSDL
     * - documentation: Value between 0 to 1073741824.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rebindingTime;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDhcpSubnet
     * @uses LDhcpSubnet::setSubnetIpAddress()
     * @uses LDhcpSubnet::setPrimaryStartIpAddress()
     * @uses LDhcpSubnet::setPrimaryEndIpAddress()
     * @uses LDhcpSubnet::setSecondaryStartIpAddress()
     * @uses LDhcpSubnet::setSecondaryEndIpAddress()
     * @uses LDhcpSubnet::setPrimaryRouterIpAddress()
     * @uses LDhcpSubnet::setSecondaryRouterIpAddress()
     * @uses LDhcpSubnet::setSubnetMask()
     * @uses LDhcpSubnet::setDomainName()
     * @uses LDhcpSubnet::setPrimaryDnsIpAddress()
     * @uses LDhcpSubnet::setSecondaryDnsIpAddress()
     * @uses LDhcpSubnet::setTftpServerName()
     * @uses LDhcpSubnet::setPrimaryTftpServerIpAddress()
     * @uses LDhcpSubnet::setSecondaryTftpServerIpAddress()
     * @uses LDhcpSubnet::setBootstrapServerIpAddress()
     * @uses LDhcpSubnet::setArpCacheTimeout()
     * @uses LDhcpSubnet::setIpAddressLeaseTime()
     * @uses LDhcpSubnet::setRenewalTime()
     * @uses LDhcpSubnet::setRebindingTime()
     * @uses LDhcpSubnet::setUuid()
     * @param string $subnetIpAddress
     * @param string $primaryStartIpAddress
     * @param string $primaryEndIpAddress
     * @param string $secondaryStartIpAddress
     * @param string $secondaryEndIpAddress
     * @param string $primaryRouterIpAddress
     * @param string $secondaryRouterIpAddress
     * @param string $subnetMask
     * @param string $domainName
     * @param string $primaryDnsIpAddress
     * @param string $secondaryDnsIpAddress
     * @param string $tftpServerName
     * @param string $primaryTftpServerIpAddress
     * @param string $secondaryTftpServerIpAddress
     * @param string $bootstrapServerIpAddress
     * @param string $arpCacheTimeout
     * @param string $ipAddressLeaseTime
     * @param string $renewalTime
     * @param string $rebindingTime
     * @param string $uuid
     */
    public function __construct($subnetIpAddress = null, $primaryStartIpAddress = null, $primaryEndIpAddress = null, $secondaryStartIpAddress = null, $secondaryEndIpAddress = null, $primaryRouterIpAddress = null, $secondaryRouterIpAddress = null, $subnetMask = null, $domainName = null, $primaryDnsIpAddress = null, $secondaryDnsIpAddress = null, $tftpServerName = null, $primaryTftpServerIpAddress = null, $secondaryTftpServerIpAddress = null, $bootstrapServerIpAddress = null, $arpCacheTimeout = null, $ipAddressLeaseTime = null, $renewalTime = null, $rebindingTime = null, $uuid = null)
    {
        $this
            ->setSubnetIpAddress($subnetIpAddress)
            ->setPrimaryStartIpAddress($primaryStartIpAddress)
            ->setPrimaryEndIpAddress($primaryEndIpAddress)
            ->setSecondaryStartIpAddress($secondaryStartIpAddress)
            ->setSecondaryEndIpAddress($secondaryEndIpAddress)
            ->setPrimaryRouterIpAddress($primaryRouterIpAddress)
            ->setSecondaryRouterIpAddress($secondaryRouterIpAddress)
            ->setSubnetMask($subnetMask)
            ->setDomainName($domainName)
            ->setPrimaryDnsIpAddress($primaryDnsIpAddress)
            ->setSecondaryDnsIpAddress($secondaryDnsIpAddress)
            ->setTftpServerName($tftpServerName)
            ->setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress)
            ->setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress)
            ->setBootstrapServerIpAddress($bootstrapServerIpAddress)
            ->setArpCacheTimeout($arpCacheTimeout)
            ->setIpAddressLeaseTime($ipAddressLeaseTime)
            ->setRenewalTime($renewalTime)
            ->setRebindingTime($rebindingTime)
            ->setUuid($uuid);
    }
    /**
     * Get subnetIpAddress value
     * @return string|null
     */
    public function getSubnetIpAddress()
    {
        return $this->subnetIpAddress;
    }
    /**
     * Set subnetIpAddress value
     * @param string $subnetIpAddress
     * @return LDhcpSubnet
     */
    public function setSubnetIpAddress($subnetIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($subnetIpAddress) && !is_string($subnetIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subnetIpAddress)), __LINE__);
        }
        $this->subnetIpAddress = $subnetIpAddress;
        return $this;
    }
    /**
     * Get primaryStartIpAddress value
     * @return string|null
     */
    public function getPrimaryStartIpAddress()
    {
        return $this->primaryStartIpAddress;
    }
    /**
     * Set primaryStartIpAddress value
     * @param string $primaryStartIpAddress
     * @return LDhcpSubnet
     */
    public function setPrimaryStartIpAddress($primaryStartIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryStartIpAddress) && !is_string($primaryStartIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryStartIpAddress)), __LINE__);
        }
        $this->primaryStartIpAddress = $primaryStartIpAddress;
        return $this;
    }
    /**
     * Get primaryEndIpAddress value
     * @return string|null
     */
    public function getPrimaryEndIpAddress()
    {
        return $this->primaryEndIpAddress;
    }
    /**
     * Set primaryEndIpAddress value
     * @param string $primaryEndIpAddress
     * @return LDhcpSubnet
     */
    public function setPrimaryEndIpAddress($primaryEndIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryEndIpAddress) && !is_string($primaryEndIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryEndIpAddress)), __LINE__);
        }
        $this->primaryEndIpAddress = $primaryEndIpAddress;
        return $this;
    }
    /**
     * Get secondaryStartIpAddress value
     * @return string|null
     */
    public function getSecondaryStartIpAddress()
    {
        return $this->secondaryStartIpAddress;
    }
    /**
     * Set secondaryStartIpAddress value
     * @param string $secondaryStartIpAddress
     * @return LDhcpSubnet
     */
    public function setSecondaryStartIpAddress($secondaryStartIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryStartIpAddress) && !is_string($secondaryStartIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryStartIpAddress)), __LINE__);
        }
        $this->secondaryStartIpAddress = $secondaryStartIpAddress;
        return $this;
    }
    /**
     * Get secondaryEndIpAddress value
     * @return string|null
     */
    public function getSecondaryEndIpAddress()
    {
        return $this->secondaryEndIpAddress;
    }
    /**
     * Set secondaryEndIpAddress value
     * @param string $secondaryEndIpAddress
     * @return LDhcpSubnet
     */
    public function setSecondaryEndIpAddress($secondaryEndIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryEndIpAddress) && !is_string($secondaryEndIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryEndIpAddress)), __LINE__);
        }
        $this->secondaryEndIpAddress = $secondaryEndIpAddress;
        return $this;
    }
    /**
     * Get primaryRouterIpAddress value
     * @return string|null
     */
    public function getPrimaryRouterIpAddress()
    {
        return $this->primaryRouterIpAddress;
    }
    /**
     * Set primaryRouterIpAddress value
     * @param string $primaryRouterIpAddress
     * @return LDhcpSubnet
     */
    public function setPrimaryRouterIpAddress($primaryRouterIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryRouterIpAddress) && !is_string($primaryRouterIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryRouterIpAddress)), __LINE__);
        }
        $this->primaryRouterIpAddress = $primaryRouterIpAddress;
        return $this;
    }
    /**
     * Get secondaryRouterIpAddress value
     * @return string|null
     */
    public function getSecondaryRouterIpAddress()
    {
        return $this->secondaryRouterIpAddress;
    }
    /**
     * Set secondaryRouterIpAddress value
     * @param string $secondaryRouterIpAddress
     * @return LDhcpSubnet
     */
    public function setSecondaryRouterIpAddress($secondaryRouterIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryRouterIpAddress) && !is_string($secondaryRouterIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryRouterIpAddress)), __LINE__);
        }
        $this->secondaryRouterIpAddress = $secondaryRouterIpAddress;
        return $this;
    }
    /**
     * Get subnetMask value
     * @return string|null
     */
    public function getSubnetMask()
    {
        return $this->subnetMask;
    }
    /**
     * Set subnetMask value
     * @param string $subnetMask
     * @return LDhcpSubnet
     */
    public function setSubnetMask($subnetMask = null)
    {
        // validation for constraint: string
        if (!is_null($subnetMask) && !is_string($subnetMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subnetMask)), __LINE__);
        }
        $this->subnetMask = $subnetMask;
        return $this;
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return LDhcpSubnet
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get primaryDnsIpAddress value
     * @return string|null
     */
    public function getPrimaryDnsIpAddress()
    {
        return $this->primaryDnsIpAddress;
    }
    /**
     * Set primaryDnsIpAddress value
     * @param string $primaryDnsIpAddress
     * @return LDhcpSubnet
     */
    public function setPrimaryDnsIpAddress($primaryDnsIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryDnsIpAddress) && !is_string($primaryDnsIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryDnsIpAddress)), __LINE__);
        }
        $this->primaryDnsIpAddress = $primaryDnsIpAddress;
        return $this;
    }
    /**
     * Get secondaryDnsIpAddress value
     * @return string|null
     */
    public function getSecondaryDnsIpAddress()
    {
        return $this->secondaryDnsIpAddress;
    }
    /**
     * Set secondaryDnsIpAddress value
     * @param string $secondaryDnsIpAddress
     * @return LDhcpSubnet
     */
    public function setSecondaryDnsIpAddress($secondaryDnsIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryDnsIpAddress) && !is_string($secondaryDnsIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryDnsIpAddress)), __LINE__);
        }
        $this->secondaryDnsIpAddress = $secondaryDnsIpAddress;
        return $this;
    }
    /**
     * Get tftpServerName value
     * @return string|null
     */
    public function getTftpServerName()
    {
        return $this->tftpServerName;
    }
    /**
     * Set tftpServerName value
     * @param string $tftpServerName
     * @return LDhcpSubnet
     */
    public function setTftpServerName($tftpServerName = null)
    {
        // validation for constraint: string
        if (!is_null($tftpServerName) && !is_string($tftpServerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tftpServerName)), __LINE__);
        }
        $this->tftpServerName = $tftpServerName;
        return $this;
    }
    /**
     * Get primaryTftpServerIpAddress value
     * @return string|null
     */
    public function getPrimaryTftpServerIpAddress()
    {
        return $this->primaryTftpServerIpAddress;
    }
    /**
     * Set primaryTftpServerIpAddress value
     * @param string $primaryTftpServerIpAddress
     * @return LDhcpSubnet
     */
    public function setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryTftpServerIpAddress) && !is_string($primaryTftpServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryTftpServerIpAddress)), __LINE__);
        }
        $this->primaryTftpServerIpAddress = $primaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get secondaryTftpServerIpAddress value
     * @return string|null
     */
    public function getSecondaryTftpServerIpAddress()
    {
        return $this->secondaryTftpServerIpAddress;
    }
    /**
     * Set secondaryTftpServerIpAddress value
     * @param string $secondaryTftpServerIpAddress
     * @return LDhcpSubnet
     */
    public function setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryTftpServerIpAddress) && !is_string($secondaryTftpServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryTftpServerIpAddress)), __LINE__);
        }
        $this->secondaryTftpServerIpAddress = $secondaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get bootstrapServerIpAddress value
     * @return string|null
     */
    public function getBootstrapServerIpAddress()
    {
        return $this->bootstrapServerIpAddress;
    }
    /**
     * Set bootstrapServerIpAddress value
     * @param string $bootstrapServerIpAddress
     * @return LDhcpSubnet
     */
    public function setBootstrapServerIpAddress($bootstrapServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bootstrapServerIpAddress) && !is_string($bootstrapServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bootstrapServerIpAddress)), __LINE__);
        }
        $this->bootstrapServerIpAddress = $bootstrapServerIpAddress;
        return $this;
    }
    /**
     * Get arpCacheTimeout value
     * @return string|null
     */
    public function getArpCacheTimeout()
    {
        return $this->arpCacheTimeout;
    }
    /**
     * Set arpCacheTimeout value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arpCacheTimeout
     * @return LDhcpSubnet
     */
    public function setArpCacheTimeout($arpCacheTimeout = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($arpCacheTimeout)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arpCacheTimeout, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->arpCacheTimeout = $arpCacheTimeout;
        return $this;
    }
    /**
     * Get ipAddressLeaseTime value
     * @return string|null
     */
    public function getIpAddressLeaseTime()
    {
        return $this->ipAddressLeaseTime;
    }
    /**
     * Set ipAddressLeaseTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressLeaseTime
     * @return LDhcpSubnet
     */
    public function setIpAddressLeaseTime($ipAddressLeaseTime = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($ipAddressLeaseTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ipAddressLeaseTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->ipAddressLeaseTime = $ipAddressLeaseTime;
        return $this;
    }
    /**
     * Get renewalTime value
     * @return string|null
     */
    public function getRenewalTime()
    {
        return $this->renewalTime;
    }
    /**
     * Set renewalTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewalTime
     * @return LDhcpSubnet
     */
    public function setRenewalTime($renewalTime = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($renewalTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $renewalTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->renewalTime = $renewalTime;
        return $this;
    }
    /**
     * Get rebindingTime value
     * @return string|null
     */
    public function getRebindingTime()
    {
        return $this->rebindingTime;
    }
    /**
     * Set rebindingTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rebindingTime
     * @return LDhcpSubnet
     */
    public function setRebindingTime($rebindingTime = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($rebindingTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rebindingTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->rebindingTime = $rebindingTime;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LDhcpSubnet
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LDhcpSubnet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
