<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedGroups StructType
 * @subpackage Structs
 */
class AssociatedGroups extends AbstractStructBase
{
    /**
     * The userGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var UserGroup[]
     */
    public $userGroup;
    /**
     * Constructor method for associatedGroups
     * @uses AssociatedGroups::setUserGroup()
     * @param UserGroup[] $userGroup
     */
    public function __construct(array $userGroup = array())
    {
        $this
            ->setUserGroup($userGroup);
    }
    /**
     * Get userGroup value
     * @return UserGroup[]|null
     */
    public function getUserGroup()
    {
        return $this->userGroup;
    }
    /**
     * Set userGroup value
     * @throws \InvalidArgumentException
     * @param UserGroup[] $userGroup
     * @return AssociatedGroups
     */
    public function setUserGroup(array $userGroup = array())
    {
        foreach ($userGroup as $associatedGroupsUserGroupItem) {
            // validation for constraint: itemType
            if (!$associatedGroupsUserGroupItem instanceof UserGroup) {
                throw new \InvalidArgumentException(sprintf('The userGroup property can only contain items of UserGroup, "%s" given', is_object($associatedGroupsUserGroupItem) ? get_class($associatedGroupsUserGroupItem) : gettype($associatedGroupsUserGroupItem)), __LINE__);
            }
        }
        $this->userGroup = $userGroup;
        return $this;
    }
    /**
     * Add item to userGroup value
     * @throws \InvalidArgumentException
     * @param UserGroup $item
     * @return AssociatedGroups
     */
    public function addToUserGroup(UserGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof UserGroup) {
            throw new \InvalidArgumentException(sprintf('The userGroup property can only contain items of UserGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->userGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return AssociatedGroups
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
