<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedEndusers StructType
 * @subpackage Structs
 */
class AssociatedEndusers extends AbstractStructBase
{
    /**
     * The enduser
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var LEnduserMember[]
     */
    public $enduser;
    /**
     * Constructor method for associatedEndusers
     * @uses AssociatedEndusers::setEnduser()
     * @param LEnduserMember[] $enduser
     */
    public function __construct(array $enduser = array())
    {
        $this
            ->setEnduser($enduser);
    }
    /**
     * Get enduser value
     * @return LEnduserMember[]|null
     */
    public function getEnduser()
    {
        return $this->enduser;
    }
    /**
     * Set enduser value
     * @throws \InvalidArgumentException
     * @param LEnduserMember[] $enduser
     * @return AssociatedEndusers
     */
    public function setEnduser(array $enduser = array())
    {
        foreach ($enduser as $associatedEndusersEnduserItem) {
            // validation for constraint: itemType
            if (!$associatedEndusersEnduserItem instanceof LEnduserMember) {
                throw new \InvalidArgumentException(sprintf('The enduser property can only contain items of LEnduserMember, "%s" given', is_object($associatedEndusersEnduserItem) ? get_class($associatedEndusersEnduserItem) : gettype($associatedEndusersEnduserItem)), __LINE__);
            }
        }
        $this->enduser = $enduser;
        return $this;
    }
    /**
     * Add item to enduser value
     * @throws \InvalidArgumentException
     * @param LEnduserMember $item
     * @return AssociatedEndusers
     */
    public function addToEnduser(LEnduserMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof LEnduserMember) {
            throw new \InvalidArgumentException(sprintf('The enduser property can only contain items of LEnduserMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->enduser[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return AssociatedEndusers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
