<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addresses StructType
 * Meta informations extracted from the WSDL
 * - documentation: Valid only for Cisco TelePresence Conference bridges | Valid only for Cisco TelePresence Conference bridges | Valid only for Cisco TelePresence Conference bridges
 * @subpackage Structs
 */
class Addresses extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges | Valid only for Cisco TelePresence Conference bridges | Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var string[]
     */
    public $address;
    /**
     * Constructor method for addresses
     * @uses Addresses::setAddress()
     * @param string[] $address
     */
    public function __construct(array $address = array())
    {
        $this
            ->setAddress($address);
    }
    /**
     * Get address value
     * @return string[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param string[] $address
     * @return Addresses
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $addressesAddressItem) {
            // validation for constraint: itemType
            if (!is_string($addressesAddressItem)) {
                throw new \InvalidArgumentException(sprintf('The address property can only contain items of string, "%s" given', is_object($addressesAddressItem) ? get_class($addressesAddressItem) : gettype($addressesAddressItem)), __LINE__);
            }
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return Addresses
     */
    public function addToAddress($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Addresses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
