<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addPlars StructType
 * @subpackage Structs
 */
class AddPlars extends XCommonMembersExtension
{
    /**
     * The plar
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var XPatternMember[]
     */
    public $plar;
    /**
     * Constructor method for addPlars
     * @uses AddPlars::setPlar()
     * @param XPatternMember[] $plar
     */
    public function __construct(array $plar = array())
    {
        $this
            ->setPlar($plar);
    }
    /**
     * Get plar value
     * @return XPatternMember[]
     */
    public function getPlar()
    {
        return $this->plar;
    }
    /**
     * Set plar value
     * @throws \InvalidArgumentException
     * @param XPatternMember[] $plar
     * @return AddPlars
     */
    public function setPlar(array $plar = array())
    {
        foreach ($plar as $addPlarsPlarItem) {
            // validation for constraint: itemType
            if (!$addPlarsPlarItem instanceof XPatternMember) {
                throw new \InvalidArgumentException(sprintf('The plar property can only contain items of XPatternMember, "%s" given', is_object($addPlarsPlarItem) ? get_class($addPlarsPlarItem) : gettype($addPlarsPlarItem)), __LINE__);
            }
        }
        $this->plar = $plar;
        return $this;
    }
    /**
     * Add item to plar value
     * @throws \InvalidArgumentException
     * @param XPatternMember $item
     * @return AddPlars
     */
    public function addToPlar(XPatternMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof XPatternMember) {
            throw new \InvalidArgumentException(sprintf('The plar property can only contain items of XPatternMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->plar[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return AddPlars
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
