<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addLanguages StructType
 * @subpackage Structs
 */
class AddLanguages extends XCommonMembersExtension
{
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var XSelfProvision[]
     */
    public $language;
    /**
     * Constructor method for addLanguages
     * @uses AddLanguages::setLanguage()
     * @param XSelfProvision[] $language
     */
    public function __construct(array $language = array())
    {
        $this
            ->setLanguage($language);
    }
    /**
     * Get language value
     * @return XSelfProvision[]|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @throws \InvalidArgumentException
     * @param XSelfProvision[] $language
     * @return AddLanguages
     */
    public function setLanguage(array $language = array())
    {
        foreach ($language as $addLanguagesLanguageItem) {
            // validation for constraint: itemType
            if (!$addLanguagesLanguageItem instanceof XSelfProvision) {
                throw new \InvalidArgumentException(sprintf('The language property can only contain items of XSelfProvision, "%s" given', is_object($addLanguagesLanguageItem) ? get_class($addLanguagesLanguageItem) : gettype($addLanguagesLanguageItem)), __LINE__);
            }
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Add item to language value
     * @throws \InvalidArgumentException
     * @param XSelfProvision $item
     * @return AddLanguages
     */
    public function addToLanguage(XSelfProvision $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof XSelfProvision) {
            throw new \InvalidArgumentException(sprintf('The language property can only contain items of XSelfProvision, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->language[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return AddLanguages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
