<?php
/**
 * This class stands for XVideoCallTrafficClass EnumType
 * @subpackage Enumerations
 */
class XVideoCallTrafficClass
{
    /**
     * Constant for value 'Immersive'
     * @return string 'Immersive'
     */
    const VALUE_IMMERSIVE = 'Immersive';
    /**
     * Constant for value 'Desktop'
     * @return string 'Desktop'
     */
    const VALUE_DESKTOP = 'Desktop';
    /**
     * Constant for value 'Mixed'
     * @return string 'Mixed'
     */
    const VALUE_MIXED = 'Mixed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IMMERSIVE
     * @uses self::VALUE_DESKTOP
     * @uses self::VALUE_MIXED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMMERSIVE,
            self::VALUE_DESKTOP,
            self::VALUE_MIXED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
