<?php
/**
 * This class stands for XURIDisambiguationPolicy EnumType
 * @subpackage Enumerations
 */
class XURIDisambiguationPolicy
{
    /**
     * Constant for value 'Always treat all dial strings as URI addresses'
     * @return string 'Always treat all dial strings as URI addresses'
     */
    const VALUE_ALWAYS_TREAT_ALL_DIAL_STRINGS_AS_URI_ADDRESSES = 'Always treat all dial strings as URI addresses';
    /**
     * Constant for value 'Phone number consists of characters 0-9, A-D, *, #, and +
     * (others treated as URI addresses)'
     * @return string 'Phone number consists of characters 0-9, A-D, *, #, and + (others treated as URI addresses)'
     */
    const VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_A_D_AND_OTHERS_TREATED_AS_URI_ADDRESSES = 'Phone number consists of characters 0-9, A-D, *, #, and + (others treated as URI addresses)';
    /**
     * Constant for value 'Phone number consists of characters 0-9, *, #, and + (others
     * treated as URI addresses)'
     * @return string 'Phone number consists of characters 0-9, *, #, and + (others treated as URI addresses)'
     */
    const VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_AND_OTHERS_TREATED_AS_URI_ADDRESSES = 'Phone number consists of characters 0-9, *, #, and + (others treated as URI addresses)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALWAYS_TREAT_ALL_DIAL_STRINGS_AS_URI_ADDRESSES
     * @uses self::VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_A_D_AND_OTHERS_TREATED_AS_URI_ADDRESSES
     * @uses self::VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_AND_OTHERS_TREATED_AS_URI_ADDRESSES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALWAYS_TREAT_ALL_DIAL_STRINGS_AS_URI_ADDRESSES,
            self::VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_A_D_AND_OTHERS_TREATED_AS_URI_ADDRESSES,
            self::VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_AND_OTHERS_TREATED_AS_URI_ADDRESSES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
