<?php
/**
 * This class stands for XTransport EnumType
 * @subpackage Enumerations
 */
class XTransport
{
    /**
     * Constant for value 'TCP'
     * @return string 'TCP'
     */
    const VALUE_TCP = 'TCP';
    /**
     * Constant for value 'UDP'
     * @return string 'UDP'
     */
    const VALUE_UDP = 'UDP';
    /**
     * Constant for value 'TLS'
     * @return string 'TLS'
     */
    const VALUE_TLS = 'TLS';
    /**
     * Constant for value 'TCP+UDP'
     * @return string 'TCP+UDP'
     */
    const VALUE_TCP_UDP = 'TCP+UDP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TCP
     * @uses self::VALUE_UDP
     * @uses self::VALUE_TLS
     * @uses self::VALUE_TCP_UDP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TCP,
            self::VALUE_UDP,
            self::VALUE_TLS,
            self::VALUE_TCP_UDP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
