<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTimeSchedule StructType
 * @subpackage Structs
 */
class XTimeSchedule extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var Members
     */
    public $members;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The isPublished
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: TimeSchedule cannot be published if it has a todOwnerId assigned to it. Only Administrative Time Schedule can be published.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPublished;
    /**
     * The timeScheduleCategory
     * Meta informations extracted from the WSDL
     * - default: Regular
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeScheduleCategory;
    /**
     * The todOwnerIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $todOwnerIdName;
    /**
     * Constructor method for XTimeSchedule
     * @uses XTimeSchedule::setName()
     * @uses XTimeSchedule::setMembers()
     * @uses XTimeSchedule::setDescription()
     * @uses XTimeSchedule::setIsPublished()
     * @uses XTimeSchedule::setTimeScheduleCategory()
     * @uses XTimeSchedule::setTodOwnerIdName()
     * @param string $name
     * @param Members $members
     * @param string $description
     * @param string $isPublished
     * @param string $timeScheduleCategory
     * @param XFkType $todOwnerIdName
     */
    public function __construct($name = null, Members $members = null, $description = null, $isPublished = false, $timeScheduleCategory = 'Regular', XFkType $todOwnerIdName = null)
    {
        $this
            ->setName($name)
            ->setMembers($members)
            ->setDescription($description)
            ->setIsPublished($isPublished)
            ->setTimeScheduleCategory($timeScheduleCategory)
            ->setTodOwnerIdName($todOwnerIdName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XTimeSchedule
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get members value
     * @return Members
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return XTimeSchedule
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XTimeSchedule
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPublished value
     * @return string|null
     */
    public function getIsPublished()
    {
        return $this->isPublished;
    }
    /**
     * Set isPublished value
     * @param string $isPublished
     * @return XTimeSchedule
     */
    public function setIsPublished($isPublished = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isPublished) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPublished, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPublished) && !is_string($isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPublished)), __LINE__);
        }
        $this->isPublished = $isPublished;
        return $this;
    }
    /**
     * Get timeScheduleCategory value
     * @return string|null
     */
    public function getTimeScheduleCategory()
    {
        return $this->timeScheduleCategory;
    }
    /**
     * Set timeScheduleCategory value
     * @uses XTimeScheduleCategory::valueIsValid()
     * @uses XTimeScheduleCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeScheduleCategory
     * @return XTimeSchedule
     */
    public function setTimeScheduleCategory($timeScheduleCategory = 'Regular')
    {
        // validation for constraint: enumeration
        if (!XTimeScheduleCategory::valueIsValid($timeScheduleCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeScheduleCategory, implode(', ', XTimeScheduleCategory::getValidValues())), __LINE__);
        }
        $this->timeScheduleCategory = $timeScheduleCategory;
        return $this;
    }
    /**
     * Get todOwnerIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getTodOwnerIdName()
    {
        return isset($this->todOwnerIdName) ? $this->todOwnerIdName : null;
    }
    /**
     * Set todOwnerIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $todOwnerIdName
     * @return XTimeSchedule
     */
    public function setTodOwnerIdName(XFkType $todOwnerIdName = null)
    {
        if (is_null($todOwnerIdName) || (is_array($todOwnerIdName) && empty($todOwnerIdName))) {
            unset($this->todOwnerIdName);
        } else {
            $this->todOwnerIdName = $todOwnerIdName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XTimeSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
