<?php
/**
 * This class stands for XSIPRel1XXOptions EnumType
 * @subpackage Enumerations
 */
class XSIPRel1XXOptions
{
    /**
     * Constant for value 'Disabled'
     * @return string 'Disabled'
     */
    const VALUE_DISABLED = 'Disabled';
    /**
     * Constant for value 'Send PRACK if 1xx Contains SDP'
     * @return string 'Send PRACK if 1xx Contains SDP'
     */
    const VALUE_SEND_PRACK_IF_1_XX_CONTAINS_SDP = 'Send PRACK if 1xx Contains SDP';
    /**
     * Constant for value 'Send PRACK for all 1xx Messages'
     * @return string 'Send PRACK for all 1xx Messages'
     */
    const VALUE_SEND_PRACK_FOR_ALL_1_XX_MESSAGES = 'Send PRACK for all 1xx Messages';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISABLED
     * @uses self::VALUE_SEND_PRACK_IF_1_XX_CONTAINS_SDP
     * @uses self::VALUE_SEND_PRACK_FOR_ALL_1_XX_MESSAGES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISABLED,
            self::VALUE_SEND_PRACK_IF_1_XX_CONTAINS_SDP,
            self::VALUE_SEND_PRACK_FOR_ALL_1_XX_MESSAGES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
