<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRoutePartition StructType
 * @subpackage Structs
 */
class XRoutePartition extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The timeScheduleIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $timeScheduleIdName;
    /**
     * The useOriginatingDeviceTimeZone
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useOriginatingDeviceTimeZone;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - default: Etc/GMT
     * - documentation: Only Applicable if TimeSchedule is selected. If OriginatingDevice is selected then this tag is not applicable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * The partitionUsage
     * Meta informations extracted from the WSDL
     * - default: General
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $partitionUsage;
    /**
     * Constructor method for XRoutePartition
     * @uses XRoutePartition::setName()
     * @uses XRoutePartition::setDescription()
     * @uses XRoutePartition::setTimeScheduleIdName()
     * @uses XRoutePartition::setUseOriginatingDeviceTimeZone()
     * @uses XRoutePartition::setTimeZone()
     * @uses XRoutePartition::setPartitionUsage()
     * @param string $name
     * @param string $description
     * @param XFkType $timeScheduleIdName
     * @param string $useOriginatingDeviceTimeZone
     * @param string $timeZone
     * @param string $partitionUsage
     */
    public function __construct($name = null, $description = null, XFkType $timeScheduleIdName = null, $useOriginatingDeviceTimeZone = true, $timeZone = 'Etc/GMT', $partitionUsage = 'General')
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setTimeScheduleIdName($timeScheduleIdName)
            ->setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone)
            ->setTimeZone($timeZone)
            ->setPartitionUsage($partitionUsage);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XRoutePartition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XRoutePartition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get timeScheduleIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getTimeScheduleIdName()
    {
        return isset($this->timeScheduleIdName) ? $this->timeScheduleIdName : null;
    }
    /**
     * Set timeScheduleIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $timeScheduleIdName
     * @return XRoutePartition
     */
    public function setTimeScheduleIdName(XFkType $timeScheduleIdName = null)
    {
        if (is_null($timeScheduleIdName) || (is_array($timeScheduleIdName) && empty($timeScheduleIdName))) {
            unset($this->timeScheduleIdName);
        } else {
            $this->timeScheduleIdName = $timeScheduleIdName;
        }
        return $this;
    }
    /**
     * Get useOriginatingDeviceTimeZone value
     * @return string|null
     */
    public function getUseOriginatingDeviceTimeZone()
    {
        return $this->useOriginatingDeviceTimeZone;
    }
    /**
     * Set useOriginatingDeviceTimeZone value
     * @param string $useOriginatingDeviceTimeZone
     * @return XRoutePartition
     */
    public function setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useOriginatingDeviceTimeZone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useOriginatingDeviceTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useOriginatingDeviceTimeZone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useOriginatingDeviceTimeZone) && !is_string($useOriginatingDeviceTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useOriginatingDeviceTimeZone)), __LINE__);
        }
        $this->useOriginatingDeviceTimeZone = $useOriginatingDeviceTimeZone;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses XTimeZone::valueIsValid()
     * @uses XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return XRoutePartition
     */
    public function setTimeZone($timeZone = 'Etc/GMT')
    {
        // validation for constraint: enumeration
        if (!XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses XPartitionUsage::valueIsValid()
     * @uses XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return XRoutePartition
     */
    public function setPartitionUsage($partitionUsage = 'General')
    {
        // validation for constraint: enumeration
        if (!XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $partitionUsage, implode(', ', XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XRoutePartition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
