<?php
/**
 * This class stands for XProcessNodeRole EnumType
 * @subpackage Enumerations
 */
class XProcessNodeRole
{
    /**
     * Constant for value 'CUCM Voice/Video'
     * @return string 'CUCM Voice/Video'
     */
    const VALUE_CUCM_VOICE_VIDEO = 'CUCM Voice/Video';
    /**
     * Constant for value 'CUCM IM and Presence'
     * @return string 'CUCM IM and Presence'
     */
    const VALUE_CUCM_IM_AND_PRESENCE = 'CUCM IM and Presence';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CUCM_VOICE_VIDEO
     * @uses self::VALUE_CUCM_IM_AND_PRESENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CUCM_VOICE_VIDEO,
            self::VALUE_CUCM_IM_AND_PRESENCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
