<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPhoneNtp StructType
 * @subpackage Structs
 */
class XPhoneNtp extends AbstractStructBase
{
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The mode
     * Meta informations extracted from the WSDL
     * - default: Directed Broadcast
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $mode;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * Constructor method for XPhoneNtp
     * @uses XPhoneNtp::setIpAddress()
     * @uses XPhoneNtp::setMode()
     * @uses XPhoneNtp::setDescription()
     * @param string $ipAddress
     * @param string $mode
     * @param string $description
     */
    public function __construct($ipAddress = null, $mode = 'Directed Broadcast', $description = null)
    {
        $this
            ->setIpAddress($ipAddress)
            ->setMode($mode)
            ->setDescription($description);
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return XPhoneNtp
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get mode value
     * @return string
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @uses XZzntpmode::valueIsValid()
     * @uses XZzntpmode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return XPhoneNtp
     */
    public function setMode($mode = 'Directed Broadcast')
    {
        // validation for constraint: enumeration
        if (!XZzntpmode::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mode, implode(', ', XZzntpmode::getValidValues())), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XPhoneNtp
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XPhoneNtp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
