<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMobileVoiceMember StructType
 * @subpackage Structs
 */
class XMobileVoiceMember extends AbstractStructBase
{
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $userLocale;
    /**
     * The orderIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $orderIndex;
    /**
     * Constructor method for XMobileVoiceMember
     * @uses XMobileVoiceMember::setUserLocale()
     * @uses XMobileVoiceMember::setOrderIndex()
     * @param string $userLocale
     * @param string $orderIndex
     */
    public function __construct($userLocale = null, $orderIndex = null)
    {
        $this
            ->setUserLocale($userLocale)
            ->setOrderIndex($orderIndex);
    }
    /**
     * Get userLocale value
     * @return string
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return XMobileVoiceMember
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get orderIndex value
     * @return string
     */
    public function getOrderIndex()
    {
        return $this->orderIndex;
    }
    /**
     * Set orderIndex value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderIndex
     * @return XMobileVoiceMember
     */
    public function setOrderIndex($orderIndex = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($orderIndex)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderIndex, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->orderIndex = $orderIndex;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XMobileVoiceMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
