<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLocationRelationship StructType
 * @subpackage Structs
 */
class XLocationRelationship extends AbstractStructBase
{
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $locationName;
    /**
     * The rsvpSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rsvpSetting;
    /**
     * Constructor method for XLocationRelationship
     * @uses XLocationRelationship::setLocationName()
     * @uses XLocationRelationship::setRsvpSetting()
     * @param XFkType $locationName
     * @param string $rsvpSetting
     */
    public function __construct(XFkType $locationName = null, $rsvpSetting = null)
    {
        $this
            ->setLocationName($locationName)
            ->setRsvpSetting($rsvpSetting);
    }
    /**
     * Get locationName value
     * @return XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return XLocationRelationship
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get rsvpSetting value
     * @return string
     */
    public function getRsvpSetting()
    {
        return $this->rsvpSetting;
    }
    /**
     * Set rsvpSetting value
     * @uses XMatrixValue::valueIsValid()
     * @uses XMatrixValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rsvpSetting
     * @return XLocationRelationship
     */
    public function setRsvpSetting($rsvpSetting = null)
    {
        // validation for constraint: enumeration
        if (!XMatrixValue::valueIsValid($rsvpSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rsvpSetting, implode(', ', XMatrixValue::getValidValues())), __LINE__);
        }
        $this->rsvpSetting = $rsvpSetting;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XLocationRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
