<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLicensedUser StructType
 * @subpackage Structs
 */
class XLicensedUser extends AbstractStructBase
{
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userId;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $lastName;
    /**
     * The snrEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $snrEnabled;
    /**
     * The emEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $emEnabled;
    /**
     * The deviceCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deviceCount;
    /**
     * The licenseType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $licenseType;
    /**
     * The licenseUsed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $licenseUsed;
    /**
     * Constructor method for XLicensedUser
     * @uses XLicensedUser::setUserId()
     * @uses XLicensedUser::setFirstName()
     * @uses XLicensedUser::setLastName()
     * @uses XLicensedUser::setSnrEnabled()
     * @uses XLicensedUser::setEmEnabled()
     * @uses XLicensedUser::setDeviceCount()
     * @uses XLicensedUser::setLicenseType()
     * @uses XLicensedUser::setLicenseUsed()
     * @param string $userId
     * @param string $firstName
     * @param string $lastName
     * @param string $snrEnabled
     * @param string $emEnabled
     * @param string $deviceCount
     * @param string $licenseType
     * @param string $licenseUsed
     */
    public function __construct($userId = null, $firstName = null, $lastName = null, $snrEnabled = null, $emEnabled = null, $deviceCount = null, $licenseType = null, $licenseUsed = null)
    {
        $this
            ->setUserId($userId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setSnrEnabled($snrEnabled)
            ->setEmEnabled($emEnabled)
            ->setDeviceCount($deviceCount)
            ->setLicenseType($licenseType)
            ->setLicenseUsed($licenseUsed);
    }
    /**
     * Get userId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->userId) ? $this->userId : null;
    }
    /**
     * Set userId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return XLicensedUser
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->userId);
        } else {
            $this->userId = $userId;
        }
        return $this;
    }
    /**
     * Get firstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->firstName) ? $this->firstName : null;
    }
    /**
     * Set firstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return XLicensedUser
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->firstName);
        } else {
            $this->firstName = $firstName;
        }
        return $this;
    }
    /**
     * Get lastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->lastName) ? $this->lastName : null;
    }
    /**
     * Set lastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return XLicensedUser
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->lastName);
        } else {
            $this->lastName = $lastName;
        }
        return $this;
    }
    /**
     * Get snrEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSnrEnabled()
    {
        return isset($this->snrEnabled) ? $this->snrEnabled : null;
    }
    /**
     * Set snrEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $snrEnabled
     * @return XLicensedUser
     */
    public function setSnrEnabled($snrEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($snrEnabled) && !is_string($snrEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($snrEnabled)), __LINE__);
        }
        if (is_null($snrEnabled) || (is_array($snrEnabled) && empty($snrEnabled))) {
            unset($this->snrEnabled);
        } else {
            $this->snrEnabled = $snrEnabled;
        }
        return $this;
    }
    /**
     * Get emEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmEnabled()
    {
        return isset($this->emEnabled) ? $this->emEnabled : null;
    }
    /**
     * Set emEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emEnabled
     * @return XLicensedUser
     */
    public function setEmEnabled($emEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($emEnabled) && !is_string($emEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emEnabled)), __LINE__);
        }
        if (is_null($emEnabled) || (is_array($emEnabled) && empty($emEnabled))) {
            unset($this->emEnabled);
        } else {
            $this->emEnabled = $emEnabled;
        }
        return $this;
    }
    /**
     * Get deviceCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceCount()
    {
        return isset($this->deviceCount) ? $this->deviceCount : null;
    }
    /**
     * Set deviceCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceCount
     * @return XLicensedUser
     */
    public function setDeviceCount($deviceCount = null)
    {
        // validation for constraint: string
        if (!is_null($deviceCount) && !is_string($deviceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceCount)), __LINE__);
        }
        if (is_null($deviceCount) || (is_array($deviceCount) && empty($deviceCount))) {
            unset($this->deviceCount);
        } else {
            $this->deviceCount = $deviceCount;
        }
        return $this;
    }
    /**
     * Get licenseType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLicenseType()
    {
        return isset($this->licenseType) ? $this->licenseType : null;
    }
    /**
     * Set licenseType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $licenseType
     * @return XLicensedUser
     */
    public function setLicenseType($licenseType = null)
    {
        // validation for constraint: string
        if (!is_null($licenseType) && !is_string($licenseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseType)), __LINE__);
        }
        if (is_null($licenseType) || (is_array($licenseType) && empty($licenseType))) {
            unset($this->licenseType);
        } else {
            $this->licenseType = $licenseType;
        }
        return $this;
    }
    /**
     * Get licenseUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLicenseUsed()
    {
        return isset($this->licenseUsed) ? $this->licenseUsed : null;
    }
    /**
     * Set licenseUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $licenseUsed
     * @return XLicensedUser
     */
    public function setLicenseUsed($licenseUsed = null)
    {
        // validation for constraint: string
        if (!is_null($licenseUsed) && !is_string($licenseUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licenseUsed)), __LINE__);
        }
        if (is_null($licenseUsed) || (is_array($licenseUsed) && empty($licenseUsed))) {
            unset($this->licenseUsed);
        } else {
            $this->licenseUsed = $licenseUsed;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XLicensedUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
